/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.creditaccount;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.creditaccount.CreditAutoRepaymentConditionConvert;
import com.elitesland.fin.application.convert.creditaccount.CreditSettingConvert;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAutoRepaymentConditionSaveParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditSettingParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAutoRepaymentConditionRespVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditSettingDetailVO;
import com.elitesland.fin.application.service.creditaccount.CreditSettingService;
import com.elitesland.fin.application.service.redis.MyRedisService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.creditaccount.CreditAutoRepaymentConditionDO;
import com.elitesland.fin.entity.creditaccount.CreditSettingDO;
import com.elitesland.fin.repo.creditaccount.CreditAutoRepaymentConditionRepo;
import com.elitesland.fin.repo.creditaccount.CreditAutoRepaymentConditionRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditSettingRepo;
import com.elitesland.fin.repo.creditaccount.CreditSettingRepoProc;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreditSettingServiceImpl
implements CreditSettingService {
    private static final Logger log = LoggerFactory.getLogger(CreditSettingServiceImpl.class);
    private final CreditSettingRepo creditSettingRepo;
    private final CreditSettingRepoProc creditSettingRepoProc;
    private final CreditAutoRepaymentConditionRepo autoRepaymentConditionRepo;
    private final CreditAutoRepaymentConditionRepoProc autoRepaymentConditionRepoProc;
    private final UdcProvider udcProvider;
    private final MyRedisService myRedisService;

    @Override
    @SysCodeProc
    public CreditSettingDetailVO detail() {
        CreditSettingDetailVO detailVO = this.creditSettingRepoProc.findAll();
        Map conditionTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getModel(), UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getCode());
        if (Objects.nonNull(detailVO)) {
            detailVO.setAutoRepaymentRespVOList(Collections.emptyList());
            List<CreditAutoRepaymentConditionDO> autoRepaymentConditionDOList = this.autoRepaymentConditionRepo.findAllByMasId(detailVO.getId());
            if (CollectionUtil.isNotEmpty(autoRepaymentConditionDOList)) {
                List<CreditAutoRepaymentConditionRespVO> autoRepaymentConditionRespVOList = autoRepaymentConditionDOList.stream().filter(Objects::nonNull).map(CreditAutoRepaymentConditionConvert.INSTANCE::doToVo).collect(Collectors.toList());
                autoRepaymentConditionRespVOList.forEach(respVO -> respVO.setConditionTypeName((String)conditionTypeUdc.get(respVO.getConditionType())));
                detailVO.setAutoRepaymentRespVOList(autoRepaymentConditionRespVOList);
            }
        }
        return detailVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(CreditSettingParam param) {
        Assert.notBlank((CharSequence)param.getGeneralParam(), (String)"\u5e38\u89c4\u53c2\u6570\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CreditSettingDetailVO detailVO = this.creditSettingRepoProc.findAll();
        CreditSettingDO saveDo = CreditSettingConvert.INSTANCE.saveParam2Do(param);
        saveDo.setEnableFlag(Boolean.TRUE);
        if (Objects.isNull(param.getPaymentPeriodFlag())) {
            saveDo.setPaymentPeriodFlag(Boolean.TRUE);
        }
        CreditSettingDO save = (CreditSettingDO)this.creditSettingRepo.save(saveDo);
        if (Objects.isNull(param.getAutoRepaymentFlag())) {
            param.setAutoRepaymentFlag(false);
        }
        this.autoRepaymentConditionRepo.deleteAllByMasId(save.getId());
        if (param.getAutoRepaymentFlag().booleanValue()) {
            List<CreditAutoRepaymentConditionSaveParam> autoRepaymentParamList = param.getAutoRepaymentParamList();
            if (CollectionUtil.isEmpty(autoRepaymentParamList)) {
                throw new BusinessException("\u81ea\u52a8\u8fd8\u6b3e\u8bbe\u7f6e\u4e3a\u662f\u65f6,\u672a\u8bbe\u7f6e\u8fd8\u6b3e\u6761\u4ef6");
            }
            HashSet serialNums = new HashSet();
            autoRepaymentParamList.stream().forEach(item -> {
                Assert.notNull((Object)item.getSerialNum(), (String)"\u5e8f\u53f7\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notEmpty((CharSequence)item.getTableName(), (String)"\u8868\u5355\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notEmpty((CharSequence)item.getColumnName(), (String)"\u5b57\u6bb5\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notEmpty((CharSequence)item.getConditionType(), (String)"\u6761\u4ef6\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notEmpty((CharSequence)item.getValueFrom(), (String)"\u4ece\u503c\u5185\u5bb9\u5fc5\u586b", (Object[])new Object[0]);
                Assert.isFalse((boolean)serialNums.contains(item.getSerialNum()), (String)"\u5e8f\u53f7\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
                serialNums.add(item.getSerialNum());
            });
            List autoRepaymentConditionDOList = autoRepaymentParamList.stream().map(saveParam -> {
                CreditAutoRepaymentConditionDO autoRepaymentConditionDO = CreditAutoRepaymentConditionConvert.INSTANCE.paramToDo((CreditAutoRepaymentConditionSaveParam)((Object)saveParam));
                autoRepaymentConditionDO.setMasId(save.getId());
                autoRepaymentConditionDO.setId(null);
                return autoRepaymentConditionDO;
            }).collect(Collectors.toList());
            this.autoRepaymentConditionRepo.saveAll(autoRepaymentConditionDOList);
        }
        return save.getId();
    }

    @Override
    public CreditSettingDetailVO detailNotUdc() {
        return this.myRedisService.getDataFromRedis("YST_FIN_CREDIT_SETTING_AND_AUTO_REPAYMENT_CONDITION", CreditSettingDetailVO.class, "\u81ea\u52a8\u8fd8\u6b3e\u8bbe\u7f6e", () -> {
            CreditSettingDetailVO detailVO = this.creditSettingRepoProc.findAll();
            if (Objects.nonNull(detailVO)) {
                detailVO.setAutoRepaymentRespVOList(Collections.emptyList());
                List<CreditAutoRepaymentConditionDO> autoRepaymentConditionDOList = this.autoRepaymentConditionRepo.findAllByMasId(detailVO.getId());
                if (CollectionUtil.isNotEmpty(autoRepaymentConditionDOList)) {
                    List<CreditAutoRepaymentConditionRespVO> autoRepaymentConditionRespVOList = autoRepaymentConditionDOList.stream().filter(Objects::nonNull).map(CreditAutoRepaymentConditionConvert.INSTANCE::doToVo).collect(Collectors.toList());
                    detailVO.setAutoRepaymentRespVOList(autoRepaymentConditionRespVOList);
                }
            }
            return detailVO;
        });
    }

    public CreditSettingServiceImpl(CreditSettingRepo creditSettingRepo, CreditSettingRepoProc creditSettingRepoProc, CreditAutoRepaymentConditionRepo autoRepaymentConditionRepo, CreditAutoRepaymentConditionRepoProc autoRepaymentConditionRepoProc, UdcProvider udcProvider, MyRedisService myRedisService) {
        this.creditSettingRepo = creditSettingRepo;
        this.creditSettingRepoProc = creditSettingRepoProc;
        this.autoRepaymentConditionRepo = autoRepaymentConditionRepo;
        this.autoRepaymentConditionRepoProc = autoRepaymentConditionRepoProc;
        this.udcProvider = udcProvider;
        this.myRedisService = myRedisService;
    }
}

