package com.elitesland.fin.application.facade.vo.expense;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.exptype
 * @date 2022/4/11 14:32
 */
@Data
public class ExpTypeVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -506533810358641102L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品编码")
    private String itemName;

    @ApiModelProperty("费用类型代码")
    private String expTypeCode;

    @ApiModelProperty("费用名称")
    private String expTypeName;

    @ApiModelProperty("启用标志")
    private Boolean enableFlag;


    @ApiModelProperty("来源单据 [UDC]yst-supp:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String sourceDoc;
    @ApiModelProperty(value = "来源单据名称")
    private String sourceDocName;

    @ApiModelProperty("来源单据类型 [UDC]yst-supp:DOC_TYPE")
    @SysCode(sys = "yst-supp", mod = "DOC_TYPE")
    private String sourceDocType;
    @ApiModelProperty(value = "来源单据类型名称")
    private String sourceDocTypeName;

    @ApiModelProperty("来源单据状态 [UDC]yst-supp:DOC_STATUS")
    @SysCode(sys = "yst-supp", mod = "DOC_STATUS")
    private String sourceDocStatus;
    @ApiModelProperty(value = "来源单据状态名称")
    private String sourceDocStatusName;

    @ApiModelProperty(value = "备注")
    private String remark;
    
    @ApiModelProperty("应收单类型明细")
    private List<ExpTypeDtlVO> dtlList;
}
