package com.elitesland.fin.domain.entity.saleinv;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.support.provider.constant.SupportBusinessObjectConstants;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票
 */
@Entity
@Table(name="sale_inv")
@org.hibernate.annotations.Table(appliesTo = "sale_inv", comment = "销售发票")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SaleInvDO extends CustomFieldBaseModel implements Serializable {


    @Column(name = "source_sys_no", columnDefinition = "varchar(32) comment '来源系统单号'")
    private String sourceSysNo;

    @Column(name = "apply_no", columnDefinition = "varchar(32) comment '开票申请单号'")
    private String applyNo;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ouCode")
    private String ouCode;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "tax_rate", columnDefinition = "decimal(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "inv_reg_no", columnDefinition = "varchar(32) comment '发票登记单号'")
    private String invRegNo;

    @Column(name = "curr_code", columnDefinition = "varchar(32) comment '币种编码'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(32) comment '币种'")
    private String currName;

    @Column(name = "local_curr_code", columnDefinition = "varchar(32) comment '本位币编码'")
    private String localCurrCode;

    @Column(name = "local_curr_name", columnDefinition = "varchar(32) comment '本位币名称'")
    private String localCurrName;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额(开票申请金额)'")
    private BigDecimal totalAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "sale_inv_title", columnDefinition = "varchar(32) comment '销售方发票抬头'")
    private String saleInvTitle;

    @Column(name = "sale_tax_no", columnDefinition = "varchar(32) comment '销售税号'")
    private String saleTaxNo;

    @Column(name = "sale_tel", columnDefinition = "varchar(32) comment '销售方电话'")
    private String saleTel;

    @Column(name = "sale_add", columnDefinition = "varchar(128) comment '销售详细地址'")
    private String saleAdd;

    @Column(name = "sale_bank", columnDefinition = "varchar(32) comment '销售方开户行'")
    private String saleBank;

    @Column(name = "sale_bank_acc", columnDefinition = "varchar(32) comment '销售方银行账号'")
    private String saleBankAcc;

    @Column(name = "sale_remark", columnDefinition = "varchar(128) comment '销售方备注'")
    private String saleRemark;

    @Column(name = "sale_id", columnDefinition = "bigint(20) comment '供应商ID'")
    private Long saleId;

    @Column(name = "sale_name", columnDefinition = "varchar(32) comment '供应商名称'")
    private String saleName;

    @Column(name = "sale_code", columnDefinition = "varchar(32) comment '供应商编码'")
    private String saleCode;

    @Column(name = "cust_inv_title", columnDefinition = "varchar(32) comment '客户方发票抬头'")
    private String custInvTitle;

    @Column(name = "cust_tax_no", columnDefinition = "varchar(32) comment '纳税人识别号'")
    private String custTaxNo;

    @Column(name = "cust_add", columnDefinition = "varchar(128) comment '客户地址'")
    private String custAdd;

    @Column(name = "cust_tel", columnDefinition = "varchar(32) comment '客户电话'")
    private String custTel;

    @Column(name = "cust_bank", columnDefinition = "varchar(32) comment '客户银行'")
    private String custBank;

    @Column(name = "cust_bank_acc", columnDefinition = "varchar(32) comment '客户银行账号'")
    private String custBankAcc;

    @Column(name = "cust_remark", columnDefinition = "varchar(128) comment '客户备注'")
    private String custRemark;

    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户id'")
    private Long custId;

    @Column(name = "cust_name", columnDefinition = "varchar(32) comment '客户名称'")
    private String custName;

    @Column(name = "cust_code", columnDefinition = "varchar(32) comment '客户编码'")
    private String custCode;

    @Column(name = "inv_user", columnDefinition = "varchar(32) comment '开票人'")
    private String invUser;

    @Column(name = "rec_user", columnDefinition = "varchar(32) comment '收款人'")
    private String recUser;

    @Column(name = "rev_user", columnDefinition = "varchar(32) comment '复核人'")
    private String revUser;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人ID'")
    private Long auditUserId;

    @Column(name = "push_method", columnDefinition = "varchar(32) comment '推送方式'")
    private String pushMethod;

    @Column(name = "phone", columnDefinition = "varchar(32) comment '手机号'")
    private String phone;

    @Column(name = "email", columnDefinition = "varchar(32) comment '邮箱'")
    private String email;

    @Column(name = "info_no", columnDefinition = "varchar(32) comment '信息表编号'")
    private String infoNo;

    @Column(name = "express_no", columnDefinition = "varchar(32) comment '快递编号'")
    private String expressNo;

    @Column(name = "inv_state", columnDefinition = "varchar(32) comment '开票状态'")
    private String invState;

    @Column(name = "audit_user", columnDefinition = "varchar(32) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_date", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditDate;

    @Column(name = "order_state", columnDefinition = "varchar(32) comment '单据状态'")
    private String orderState;

    @Column(name = "exchange_rate", columnDefinition = "decimal(18,8) comment '汇率'")
    private BigDecimal exchangeRate;

    @Column(name = "audit_rejection", columnDefinition = "varchar(128) comment '审核拒绝理由'")
    private String auditRejection;

    @Column(name = "create_mode", columnDefinition = "varchar(32) comment '单据来源'")
    private String createMode;

    @Column(name = "inv_type", columnDefinition = "varchar(32) comment '发票类型'")
    private String invType;

    @Column(name = "proc_inst_id", columnDefinition = "varchar(64) comment '流程实例ID'")
    private String procInstId;

    @Column(name = "proc_inst_status", columnDefinition = "varchar(32) comment '流程实例状态'")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Column(name = "submit_time", columnDefinition = "datetime(6) comment '提交时间'")
    private LocalDateTime submitTime;

    @Column(name = "approved_time", columnDefinition = "datetime(6) comment '审批通过时间'")
    private LocalDateTime approvedTime;

    @Column(name = "inv_merge", columnDefinition = "varchar(2) comment '相同商品合并开票：1是；0否；'")
    private String invMerge;

//    @Column(name = "es1", columnDefinition = "varchar(32) comment '集团编码'")
//    private String es1;
//
//    @Column(name = "es2", columnDefinition = "varchar(32) comment '开票类型编码'")
//    private String es2;
//
    @Column(name = "settlement_type", columnDefinition = "varchar(32) comment '结算方式'")
    private String settlementType;

    @ApiModelProperty("主客户编码")
    @Column(name = "main_cust_code", columnDefinition = "varchar(32) comment '主客户编码'")
    private String mainCustCode;

    @ApiModelProperty("主客户名称")
    @Column(name = "main_cust_name", columnDefinition = "varchar(32) comment '主客户名称'")
    private String mainCustName;

    @ApiModelProperty("主客户id")
    @Column(name = "main_cust_id", columnDefinition = "bigint(20) comment '主客户id'")
    private Long mainCustId;

    @ApiModelProperty("集团编码")
    @Column(name = "pk_group", columnDefinition = "varchar(32) comment '集团编码'")
    private String pkGroup;

    @ApiModelProperty("开票类型编码")
    @Column(name = "open_inv_type", columnDefinition = "varchar(32) comment '开票类型编码'")
    private String openInvType;

    @Column(name = "inv_cust_name", columnDefinition = "varchar(32) comment '开票客户名称'")
    private String invCustName;

    @Column(name = "inv_cust_code", columnDefinition = "varchar(32) comment '开票客户编码'")
    private String invCustCode;

    @ApiModelProperty("开票客户ID")
    @Column(name = "inv_cust_id", columnDefinition = "bigint(20) comment '开票客户ID'")
    private Long invCustId;

    @Column(name = "draw_date", columnDefinition = "datetime(6) comment '开票日期'")
    private LocalDateTime drawDate;

    @ApiModelProperty("是否生成应收")
    @Column(name = "ar_flag", columnDefinition = "bigint(20) comment '是否生成应收'")
    private Boolean arFlag;

    @Column(name = "red_punch_date", columnDefinition = "datetime(6) comment '红冲日期'")
    private LocalDateTime redPunchDate;

    @ApiModelProperty("对账类型")
    @Column(name = "doc_type3", columnDefinition = "varchar(32) comment '对账类型'")
    private String docType3;

    @Column(name = "recv_contact_name", columnDefinition = "varchar(40) default null  comment '订货人'")
    private String recvContactName;

    @Column(name = "recv_contact_tel", columnDefinition = "varchar(40) default null  comment '订货联系电话'")
    private String recvContactTel;

    @Column(name = "auto_flag", columnDefinition = "tinyint(1) comment '是否自动完成'")
    private Boolean autoFlag;

    @ApiModelProperty(value = "开票抬头类型")
    @Comment("开票抬头类型")
    @Column(columnDefinition = "varchar(40)")
    private String invTitleType;

    @ApiModelProperty(value = "开票联系人")
    @Comment("开票联系人")
    @Column(columnDefinition = "longtext")
    private String invPicName;

    @ApiModelProperty(value = "开票联系人电话")
    @Comment("开票联系人电话")
    @Column(columnDefinition = "longtext")
    private String invPicPhone;

    @ApiModelProperty(value = "开票邮箱")
    @Comment("开票邮箱")
    @Column(columnDefinition = "longtext")
    private String invEmail;

    @Comment(value = "业务单据：上传外部系统的状态")
    @Column()
    private String externalStatus;

    @Comment(value = "业务单据：上传外部系统失败原因")
    @Column(columnDefinition = "MEDIUMTEXT")
    private String externalReason;

    @Column(name = "rec_apply_time", columnDefinition = "datetime default null  comment '对账申请时间'")
    private LocalDateTime recApplyTime;

    @ApiModelProperty(value = "门店编码")
    @Comment("门店编码")
    @Column(columnDefinition = "varchar(40)")
    private String storeCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SaleInvDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SaleInvDO entity = (SaleInvDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}
