/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.creditaccount;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountRuleConfigConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountRuleConfigDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountRuleConfigQueryVO;
import com.elitesland.fin.domain.service.creditaccount.CreditAccountRuleConfigDomainService;
import com.elitesland.fin.entity.creditaccount.CreditAccountRuleConfigDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountRuleConfigRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRuleConfigRepoProc;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class CreditAccountRuleConfigDomainServiceImpl
implements CreditAccountRuleConfigDomainService {
    private final CreditAccountRuleConfigRepo accountRuleConfigRepo;
    private final CreditAccountRuleConfigRepoProc accountRuleConfigRepoProc;

    @Override
    @SysCodeProc
    public Optional<CreditAccountRuleConfigDO> findById(Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return Optional.empty();
        }
        return this.accountRuleConfigRepo.findById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(Long id) {
        this.accountRuleConfigRepo.deleteById(id);
    }

    @Override
    public void updateDynamically(CreditAccountRuleConfigDO invSceneConfigDO) {
        this.accountRuleConfigRepoProc.updateDynamically(invSceneConfigDO);
    }

    @Override
    public PagingVO<CreditAccountRuleConfigPageVO> searchPage(CreditAccountRuleConfigQueryParam param) {
        return this.accountRuleConfigRepoProc.searchPage(param);
    }

    @Override
    public List<CreditAccountRuleConfigQueryVO> findRuleConfigByRuleCode(String ruleCode) {
        List<CreditAccountRuleConfigDO> sceneConfigDOS = this.accountRuleConfigRepo.findAllByRuleCode(ruleCode);
        return sceneConfigDOS.stream().map(CreditAccountRuleConfigConvert.INSTANCE::do2VO).collect(Collectors.toList());
    }

    @Override
    public CreditAccountRuleConfigDTO findByRuleCode(String ruleCode) {
        List<CreditAccountRuleConfigDO> sceneConfigDOS = this.accountRuleConfigRepo.findAllByRuleCode(ruleCode);
        if (!CollectionUtils.isEmpty(sceneConfigDOS)) {
            return CreditAccountRuleConfigConvert.INSTANCE.do2DTO(sceneConfigDOS.get(0));
        }
        return null;
    }

    public CreditAccountRuleConfigDomainServiceImpl(CreditAccountRuleConfigRepo accountRuleConfigRepo, CreditAccountRuleConfigRepoProc accountRuleConfigRepoProc) {
        this.accountRuleConfigRepo = accountRuleConfigRepo;
        this.accountRuleConfigRepoProc = accountRuleConfigRepoProc;
    }
}

