package com.elitesland.fin.application.convert.paymentperiod;

import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeOuVO;
import com.elitesland.fin.domain.entity.paymentperiod.AgingRangeOuDO;
import com.elitesland.fin.infr.dto.paymentperiod.AgingRangeOuDTO;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/17
 * @Version 1.0
 * @Content:
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface AgingRangeOuConvert {
    AgingRangeOuConvert INSTANCE = Mappers.getMapper(AgingRangeOuConvert.class);


    /**
     * saveVO转换DO
     *
     * @param saveParam 入参
     * @return DO
     */
    AgingRangeOuDO saveVoToDo(AgingRangeOuSaveParam saveParam);

    /**
     * DO转换VO
     *
     * @param agingRangeOuDO 入参
     * @return VO
     */
    AgingRangeOuVO doToRespVo(AgingRangeOuDO agingRangeOuDO);

    /**
     * DO转换DTO
     *
     * @param agingRangeOuDO 入参
     * @return DTO
     */
    AgingRangeOuDTO doToDto(AgingRangeOuDO agingRangeOuDO);

    /**
     * dto转换vo
     *
     * @param dto 入参
     * @return vo
     */
    AgingRangeOuVO dtoToVo(AgingRangeOuDTO dto);

}
