package com.elitesland.fin.application.facade.vo.arorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author lucan.liu
 * @date 2023-09-05 23:14
 */
@Data
public class ArOrderDtlExVo extends ArOrderDtlVO implements Serializable {

    private static final long serialVersionUID = 2467543369673444368L;

    @ApiModelProperty("应收单主表扩展表关联id")
    private Long masId;

    @ApiModelProperty("应收单明细id")
    private Long arDId;

    @ApiModelProperty("应收单主表关联id")
    @Column(name = "relate_id", columnDefinition = "bigint(20)  comment '应收明细表关联id'")
    private Long relateId;

    @ApiModelProperty("应收单ID")
    private Long arOrderId;

    @ApiModelProperty(value = "应收单编码")
    private String arOrderNo;

    @ApiModelProperty("发货单号")
    @Column(name = "send_order", columnDefinition = "varchar(32)  comment '发货单号'")
    private String sendOrder;

    @ApiModelProperty("第三方应收单明细id")
    @Column(name = "third_order_dt_id", columnDefinition = "varchar(32) comment '第三方应收单明细id'")
    private String thirdOrderDtId;

    @ApiModelProperty("发货单明细ID（开票申请单）")
    @Column(name = "application_dt_id", columnDefinition = "varchar(32)  comment '发货单明细ID（开票申请单）'")
    private String applicationDtId;

    @ApiModelProperty("订单客户")
    @Column(name = "order_customer", columnDefinition = "varchar(32)  comment '订单客户'")
    private String orderCustomer;

    @ApiModelProperty("未税单价")
    @Column(name = "unitprice_before_tax", columnDefinition = "decimal(16,4)  comment '未税单价'")
    private BigDecimal unitpriceBeforeTax;

    @ApiModelProperty("税码")
    @Column(name = "tax_code", columnDefinition = "varchar(32)  comment '税码'")
    private String taxCode;

    @ApiModelProperty("发票号")
    @Column(name = "invoice_number", columnDefinition = "varchar(32)  comment '发票号'")
    private String invoiceNumber;

    @ApiModelProperty(value = "发票类型")
    @SysCode(sys = "yst-oldcityfood-interact", mod = "IVN_TYPE")
    private String invoiceType;
    private String invoiceTypeName;

    @ApiModelProperty("收款协议")
    @Column(name = "recive_agreement", columnDefinition = "varchar(32)  comment '收款协议'")
    private String reciveAgreement;

    @ApiModelProperty("业务员编码")
    @Column(name = "business_code", columnDefinition = "varchar(32)  comment '业务员编码'")
    private String businessCode;

    @ApiModelProperty("业务员名称")
    private String businessName;

    @ApiModelProperty("币种")
    @Column(name = "curr_code", columnDefinition = "varchar(32)  comment '币种'")
    private String currCode;

    @ApiModelProperty("汇率")
    @Column(name = "exchange_rate", columnDefinition = "varchar(32)  comment '汇率'")
    private String exchangeRate;

    @ApiModelProperty("起算日期")
    @Column(name = "start_date", columnDefinition = "datetime(6)  comment '起算日期'")
    private LocalDateTime startDate;

    @ApiModelProperty("到期付款日")
    @Column(name = "payment_due_date", columnDefinition = "datetime(6)  comment '到期付款日'")
    private LocalDateTime paymentDueDate;


    @ApiModelProperty("第三方应收单号")
    private String sourceNo;

    @ApiModelProperty("销售公司")
    private String ouCode;

    @ApiModelProperty("费用部门")
    private String buName;

    @ApiModelProperty("业务员")
    private String saleUser;

    @ApiModelProperty("开票日期")
    private LocalDateTime invDate;

    @ApiModelProperty("渠道类型")
    @SysCode(sys = "yst-supp", mod = "SALE_CHANNEL")
    private String soSource;
    private String soSourceName;

    @ApiModelProperty("订货人")
    private String recvContactName;

    @ApiModelProperty("订货人联系电话")
    private String recvContactTel;

    @ApiModelProperty("订货地址")
    private String recDetailaddr;

    @ApiModelProperty("打款方式")
    private String payMethod;

    @ApiModelProperty("子客户名称")
    private String custName;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("销售公司")
    private String ouName;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("应收单类型")
    private String arOrderType;

    @ApiModelProperty("客户名称")
    private String customName;

    @ApiModelProperty("商品规格型号")
    private String itemSpec;

	@ApiModelProperty("nc订单号")
	private String salSoDocNo;

	@ApiModelProperty("arOrder主表上的buCode")
	private String masBuCode;

    @ApiModelProperty("主表总金额")
    private BigDecimal mainTotalAmt;


    @ApiModelProperty(value = "应收单ID")
    private Long arId;

    @ApiModelProperty(value = "应收单号")
    private String arDocNo;

    @ApiModelProperty(value = "第三方应收单号")
    private String outArDocNo;


    @ApiModelProperty(value = "业务员名称")
    private String salesmanName;

    @ApiModelProperty(value = "外部应收单明细ID")
    private String outArDId;

    @ApiModelProperty(value = "订货人")
    private String ordererName;

    @ApiModelProperty(value = "订货人电话")
    private String ordererPhone;

    @ApiModelProperty(value = "订货人地址")
    private String ordererAddr;

    @ApiModelProperty(value = "未核销金额")
    private BigDecimal notVerAmt;

    @ApiModelProperty("开票类型")
    private String invType;

    @ApiModelProperty(value = "渠道类型")
    private String chanType;

    @ApiModelProperty(value = "子客户名称")
    private String subCustName;
}
