package com.elitesland.fin.application.service.excel.exp;


import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.facade.param.account.AccountSnapshotParam;
import com.elitesland.fin.application.facade.vo.account.AccountSnapshotVo;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.excel.entity.AccountSnapshotExportEntity;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 品牌导出
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/2/2210:10
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class AccountSnapshotExportServiceImpl implements DataExport<AccountSnapshotExportEntity, AccountSnapshotParam> {

    private final AccountService accountService;

    @Override
    public String getTmplCode() {
        return "fin_account_snapshot_export";
    }

    @Override
    @BusinessObjectOperation(permissionRef = FinBusinessObjectConstant.FIN_ACCOUNT_SNAPSHOT_LIST, businessObjectType = FinBusinessObjectConstant.FIN_ACCOUNT,
            operationType = OperationTypeEnum.EXPORT, operationDescription = "账户快照导出",operationCode = FinBusinessObjectConstant.FIN_ACCOUNT_SNAPSHOT_EXPORT,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public PagingVO<AccountSnapshotExportEntity> executeExport(AccountSnapshotParam queryParam) {

        PagingVO<AccountSnapshotVo> pagingVO = accountService.querySnapshot(queryParam);

        return new PagingVO<>(
            pagingVO.getTotal(),
            ExcelConvertUtils.convertLoosely(pagingVO.getRecords(), AccountSnapshotExportEntity.class)
        );

    }
}
