package com.elitesland.fin.application.facade.vo.flow;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitesland.support.provider.constant.SupportBusinessObjectConstants;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel(value = "公司账户流水", description = "公司账户流水")
@Data
public class OuIoFlowVO extends CustomFieldBaseModelVo {

    private static final long serialVersionUID = -1054009199148215172L;

    @ApiModelProperty("出账公司编码'")
    private String oOuCode;

    @ApiModelProperty("入账公司编码'")
    private String iOuCode;

    @ApiModelProperty("发生金额'")
    private BigDecimal amount;

    @ApiModelProperty("流水号'")
    private String flowNo;

    @ApiModelProperty("关联流水号'")
    private String relateFlowNo;

    @ApiModelProperty("来源单据'")
    private String sourceDoc;

    @ApiModelProperty("来源单号'")
    private String sourceNo;

    @ApiModelProperty("来源单据ID")
    private Long sourceId;

    @ApiModelProperty("单据状态")
    private String orderStatus;

    @ApiModelProperty("来源单据状态")
    private String sourceDocStatus;

    @ApiModelProperty("账户类型")
    private String accountType;

    @ApiModelProperty("业务类型")
    private String businessType;

    @ApiModelProperty("表分区字段：月")
    private Integer ym;

    @ApiModelProperty("同步状态")
    private String syncStatus;

    @ApiModelProperty("同步异常日志")
    private String syncLog;

    @ApiModelProperty("出账方账号")
    private String fromAccountNo;

    @ApiModelProperty("入账方账号")
    private String toAccountNo;
}
