package com.elitesland.fin.provider.expense;

import cn.hutool.json.JSONUtil;
import com.elitesland.fin.Application;
import com.elitesland.fin.domain.expense.ExpTypeDtlDO;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDTO;
import com.elitesland.fin.infr.repo.expense.ExpTypeDtlRepo;
import com.elitesland.fin.infr.repo.expense.ExpTypeRepoProc;
import com.elitesland.fin.param.expense.ExpTypeDtlRpcVO;
import com.elitesland.fin.param.expense.ExpTypeQueryRpcParam;
import com.elitesland.fin.param.expense.ExpTypeQueryRpcRespPVO;
import com.elitesland.fin.service.expense.ExpenseTypeRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/8/16 13:12
 * @Description:
 */
@RequiredArgsConstructor
@Slf4j
@RestController
@RequestMapping(Application.URI_PREFIX + ExpenseTypeRpcService.PATH)
public class ExpenseTypeRpcServiceImpl implements ExpenseTypeRpcService {

    private final ExpTypeRepoProc expTypeRepoProc;
    private final ExpTypeDtlRepo expTypeDtlRepo;

    @Override
    public ExpTypeQueryRpcRespPVO getList(ExpTypeQueryRpcParam param) {
        log.info("费用类型rpc查询-参数:{}", JSONUtil.toJsonStr(param));
        ExpTypeQueryRpcRespPVO result = new ExpTypeQueryRpcRespPVO();
        ExpTypeDTO byExpTypeCode = expTypeRepoProc.findByExpTypeCode(param.getExpTypeCode());
        log.info("费用类型rpc查询-主表结果:{}", JSONUtil.toJsonStr(byExpTypeCode));
        result.setExpTypeCode(byExpTypeCode.getExpTypeCode());
        result.setExpTypeName(byExpTypeCode.getExpTypeName());
        result.setItemCode(byExpTypeCode.getItemCode());
        result.setItemName(byExpTypeCode.getItemName());
        List<ExpTypeDtlDO> typeDtlDOS = expTypeDtlRepo.findAllByMasId(byExpTypeCode.getId());
        log.info("费用类型rpc查询-明细表结果:{}", JSONUtil.toJsonStr(byExpTypeCode));
        List<ExpTypeDtlRpcVO> dtlRpcVOS = typeDtlDOS.stream().map(
                e -> {
                    ExpTypeDtlRpcVO vo = new ExpTypeDtlRpcVO();
                    vo.setSourceDocType(e.getSourceDocType());
                    vo.setSourceDoc(e.getSourceDoc());
                    vo.setSourceDocStatus(e.getSourceDocStatus());
                    return vo;
                }
        ).collect(Collectors.toList());
        result.setDtlList(dtlRpcVOS);
        log.info("费用类型rpc查询-结果:{}", JSONUtil.toJsonStr(result));
        return result;
    }
}
