package com.elitesland.fin.application.facade.excel.convert;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.utils.excel.convert.Converter;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.data.util.Pair;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class PriceRoundConverter extends Converter<BigDecimal, BigDecimal, Pair<Integer, RoundingMode>> {
    private static final SystemRpcService systemRpcService = SpringContextHolder.getBean(SystemRpcService.class);
    
    @Override
    public BigDecimal convert(BigDecimal value) {
        if(value == null) {
            value = BigDecimal.ZERO;
        }
        if (baseValue == null) {
            return value;
        }
        Integer scale = baseValue.getFirst();
        RoundingMode roundingMode = baseValue.getSecond();
        return NumberUtils.toScaledBigDecimal(value, scale, roundingMode);
    }
    
    @Override
    public synchronized Pair<Integer, RoundingMode> initBaseValue() {
        return baseValue = setPriceAccuracyBySettingService();
    }
    
    @Override
    public synchronized Pair<Integer, RoundingMode> refreshBaseValue() {
        return baseValue = setPriceAccuracyBySettingService();
    }
    
    private Pair<Integer, RoundingMode> setPriceAccuracyBySettingService() {
        SysSettingVO priceDecimalPlace = systemRpcService.findSysSettingByNo("PRICE_DECIMAL_PLACE");
        SysSettingVO priceRoundingModeValue = systemRpcService.findSysSettingByNo("PRICE_ROUNDING_MODE_VALUE");
        Integer scale = 0;
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if(priceDecimalPlace != null
            && priceDecimalPlace.getSettingVal() != null
            && !priceDecimalPlace.getSettingVal().equals("")) {
            scale = Integer.parseInt(priceDecimalPlace.getSettingVal());
        }
        if(priceRoundingModeValue != null
            && priceRoundingModeValue.getSettingVal() != null
            && priceRoundingModeValue.getSettingVal().equals("")) {
            roundingMode = RoundingMode.valueOf(Integer.parseInt(priceRoundingModeValue.getSettingVal()));
        }
        return Pair.of(scale, roundingMode);
    }
}
