package com.elitesland.fin.rpc.sale;

import com.elitesland.sale.api.vo.param.crm.AllowShipCustGroupDParam;
import com.elitesland.sale.api.vo.resp.crm.AllowShipCustGroupDVO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.api.vo.resp.crm.CustBelongOuDTO;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.sale.dto.CrmCustBaseDTO;
import com.elitesland.sale.dto.CustBaseInfoDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;

import java.util.List;
import java.util.Map;

public interface RmiSaleRpcService {

    List<LmSaveCustRespVO> findInvCust(List<String> custCodeList);

    List<AllowShipCustGroupDVO> getCustGroupInfo(AllowShipCustGroupDParam param);

    /**
     * 根据客户编码获取客户组编码
     */
    String getCustGroupCodeByCustCode(String custCode);

    /**
     * 查询客户银行信息
     *
     * @param custCode
     * @return
     */
    List<RmiOrgBankAccRpcVO> findBankAccByCustCode(String custCode);

    /**
     * 获取客户基本信息
     *
     * @param custCodes
     * @return
     */
    List<CrmCustBaseDTO> getCustBaseInfo(List<String> custCodes);

    List<CustBaseDTO> findBaseCustByCodes(List<String> custCodes);

    List<CustBaseDTO> findBaseCustByParam(CustBaseRpcParam custBaseRpcParam);

    Map<String, CustBaseDTO> findBaseCustMapByCodes(List<String> custCodes);

    List<CustBaseInfoDTO> getCustBaseInfoByCode(List<String> custCodes);

    List<CustBelongOuDTO> findCustBelongOuByCustCode(String custCode);
}
