/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.unionpay.config;

import com.alibaba.fastjson.JSONObject;
import com.chinapay.secss.SecssUtil;
import com.google.common.base.Charsets;
import java.net.URLDecoder;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnionPaySecssUtil {
    private static final Logger log = LoggerFactory.getLogger(UnionPaySecssUtil.class);
    @Autowired
    private SecssUtil secssUtil;

    public synchronized String getSign(TreeMap<String, Object> req) {
        this.secssUtil.sign(req);
        log.info("\u5f85\u7b7e\u540d\u4fe1\u606fis {}\uff0c\u7b7e\u540d\u54cd\u5e94: {}", (Object)this.secssUtil.getErrCode(), (Object)this.secssUtil.getErrMsg());
        String sign = this.secssUtil.getSign();
        return sign;
    }

    public synchronized String getDecData(String encData) {
        try {
            String cardTranData = URLDecoder.decode(encData, Charsets.UTF_8);
            this.secssUtil.decryptData(cardTranData);
            String cardData = this.secssUtil.getDecValue();
            if (StringUtils.isNotEmpty((CharSequence)cardData)) {
                Map map = (Map)JSONObject.parseObject((String)cardData, Map.class);
                return (String)map.get("CardNo");
            }
            return "";
        }
        catch (Exception e) {
            log.warn("\u94f6\u884c\u8d26\u6237\u5b57\u6bb5\u89e3\u7b7e\u9519\u8bef");
            return "";
        }
    }
}

