package com.elitesland.fin.application.facade.dto.writeoff;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 应收单详情信息
 */
@Data
public class ArOrderExDtDTO implements Serializable {

    private static final long serialVersionUID = 2161244210813335471L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("应收单明细Id")
    private Long arDId;

    @ApiModelProperty("应收单主表扩展表关联id")
    private Long masId;

    @ApiModelProperty(value = "应收单明细表关联id(必填)")
    @NotNull(message = "应收单明细表关联id不能为空")
    private Long relateId;

    @ApiModelProperty("应收单ID")
    private Long arOrderId;

    @ApiModelProperty(value = "应收单编码")
    private String arOrderNo;

    @ApiModelProperty(value = "发货单号(必填)")
    @NotBlank(message = "发货单号不能为空")
    private String sendOrder;

    @ApiModelProperty(value = "第三方应收单id(必填)")
    @NotBlank(message = "第三方应收单id不能为空")
    private String thirdOrderDtId;

    @ApiModelProperty(value = "明细ID（开票申请单）(必填)")
    @NotBlank(message = "明细ID（开票申请单）不能为空")
    private String applicationDtId;

    @ApiModelProperty(value = "订单客户(必填)")
    @NotBlank(message = "订单客户不能为空")
    private String orderCustomer;

    @ApiModelProperty(value = "客户编码(必填)")
    @NotBlank(message = "客户编码不能为空")
    private String custCode;

    @ApiModelProperty(value = "子客户编码")
    private String subCustCode;

    @ApiModelProperty(value = "商品编码(必填)")
    @NotBlank(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty(value = "数量(必填)")
    @NotBlank(message = "数量不能为空")
    private String qty;

    @ApiModelProperty(value = "未税单价(必填)")
    @NotBlank(message = "未税单价不能为空")
    private String unitpriceBeforeTax;

    @ApiModelProperty(value = "含税单价(必填)")
    @NotBlank(message = "含税单价不能为空")
    private String price;

    @ApiModelProperty(value = "原币未税金额(必填)")
    @NotBlank(message = "原币未税金额不能为空")
    private String exclTaxAmt;

    @ApiModelProperty(value = "本币未税金额(必填)")
    @NotBlank(message = "本币未税金额不能为空")
    private String exclTaxCurAmt;

    @ApiModelProperty(value = "税码(必填)")
    @NotBlank(message = "税码不能为空")
    private String taxCode;

    @ApiModelProperty(value = "税额(必填)")
    @NotBlank(message = "税额不能为空")
    private String taxAmt;

    @ApiModelProperty(value = "税率(必填)")
    @NotNull(message = "税率不能为空")
    private String taxRate;

    @ApiModelProperty(value = "发票号(必填)")
    @NotBlank(message = "发票号不能为空")
    private String invoiceNumber;

    @ApiModelProperty(value = "发票类型(必填)")
    @NotBlank(message = "发票类型不能为空")
    private String invoiceType;

    @ApiModelProperty(value = "备注(必填)")
    @NotBlank(message = "备注不能为空")
    private String remark;

    @ApiModelProperty(value = "收款协议(必填)")
    @NotBlank(message = "收款协议不能为空")
    private String reciveAgreement;

    @ApiModelProperty(value = "部门编码(必填)")
    @NotBlank(message = "部门编码不能为空")
    private String buCode;

    @ApiModelProperty(value = "业务员编码(必填)")
    @NotBlank(message = "业务员编码不能为空")
    private String businessCode;

    @ApiModelProperty(value = "币种(必填)")
    @NotBlank(message = "币种不能为空")
    private String currCode;

    @ApiModelProperty(value = "汇率(必填)")
    @NotBlank(message = "汇率不能为空")
    private String exchangeRate;

    @ApiModelProperty(value = "原币含税金额(必填)")
    @NotBlank(message = "原币含税金额不能为空")
    private String totalAmt;

    @ApiModelProperty(value = "本币含税金额(必填)")
    @NotBlank(message = "本币含税金额不能为空")
    private String totalCurAmt;

    @ApiModelProperty(value = "起算日期(必填)")
    @NotNull(message = "起算日期不能为空")
    private LocalDateTime startDate;

    @ApiModelProperty(value = "到期付款日(必填)")
    @NotNull(message = "到期付款日不能为空")
    private LocalDateTime paymentDueDate;

    @ApiModelProperty(value = "第三方应收单号")
    private String sourceNo;

    @ApiModelProperty("销售公司")
    private String ouCode;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("开票日期")
    private LocalDateTime invDate;

    @ApiModelProperty("客户名称")
    private String customName;

    @ApiModelProperty("子客户名称")
    private String custName;

    @ApiModelProperty("渠道类型")
    @SysCode(sys = "yst-supp", mod = "SALE_CHANNEL")
    private String soSource;
    private String soSourceName;

    @ApiModelProperty("订货人")
    private String recvContactName;

    @ApiModelProperty("订货人联系电话")
    private String recvContactTel;

    @ApiModelProperty("订货地址")
    private String recDetailaddr;

    @ApiModelProperty("打款方式")
    private String payMethod;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("销售公司")
    private String ouName;

    @ApiModelProperty("费用部门")
    private String buName;

    @ApiModelProperty("业务员名称")
    private String businessName;

	@ApiModelProperty("业务员")
	private String saleUser;

	@ApiModelProperty("nc订单号")
	private String salSoDocNo;
}
