package com.elitesland.fin.application.facade.vo.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "账套")
public class FinSetOfBookVO extends BaseModelVO {

    @ApiModelProperty("账套编码")
    private String sobCode;

    @ApiModelProperty("账套名称")
    private String sobName;

    @ApiModelProperty("会计期间编码")
    private String accountPeriodCode;

    @ApiModelProperty("会计期间名称")
    private String accountPeriodName;

    @ApiModelProperty("本位币")
    private String currCode;

    @ApiModelProperty("本位币名称")
    private String currName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("账套明细")
    private List<FinSetOfBookLineVO> dimenDetailList;

    @ApiModelProperty("账套公司")
    private List<FinSetOfBookOuVO> ouDetailList;

    @ApiModelProperty("期间年份")
    private List<String> yearList;
}
