package com.elitesland.fin.application.service.workflow.adjust;

import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;

import java.util.ArrayList;

/**
 * @author Jason.zhao
 * @date 2022/5/7 10:22
 */
public interface FinAdjustOrderProcessService {

    /**
     * 回调
     *
     * @param businessKey     业务主键
     * @param procInstStatus 业务状态
     */
    void processStatusChange(String businessKey, ProcInstStatus procInstStatus, CommentInfo commentInfo);

    /**
     * 根据公司和角色编码查找对应处理人
     *
     * @param businessKey  业务主键
     * @param customParams 自定义编码
     *
     * @return 用户id
     */
    ArrayList<String> taskAssignee(String businessKey, String customParams);

}
