package com.elitesland.fin.entity.expense;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Entity
@Table(name = "expense_rule_config_dtl")
@org.hibernate.annotations.Table(appliesTo = "expense_rule_config_dtl", comment = "费用计算规则配置明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
@ApiModel(value = "expense_rule_config_dtl", description = "费用计算规则配置明细")
public class ExpRuleConfigDtlDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -6829086191452645974L;

    @ApiModelProperty(value = "主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表ID'")
    private Long masId;

    @ApiModelProperty(value = "执行序列")
    @Column(name = "range_type", columnDefinition = "varchar(64)  comment '范围类型'")
    private String rangeType;

    @ApiModelProperty(value = "范围id")
    @Column(name = "range_id", columnDefinition = "bigint  comment '范围id'")
    private Long rangeId;

    @ApiModelProperty(value = "范围编码")
    @Column(name = "range_code", columnDefinition = "varchar(255)  comment '范围编码'")
    private String rangeCode;

    @ApiModelProperty(value = "范围名称")
    @Column(name = "range_name", columnDefinition = "varchar(255)  comment '范围名称'")
    private String rangeName;
}