package com.elitesland.fin.entity.invoice;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author sunxw
 * @description
 * @Date 2023/8/4
 */
@Entity
@Table(name = "fin_payment_charges_d")
@org.hibernate.annotations.Table(appliesTo = "fin_payment_charges_d", comment = "费用记录明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "费用记录明细表", description = "费用记录明细表")
@Where(clause = "delete_flag = 0")
public class PaymentChargesDDO extends BaseModel implements Serializable {

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "fee_rule_code", columnDefinition = "varchar(64) comment '收费规则编码'")
    private String feeRuleCode;

    @Column(name = "charges_amt", columnDefinition = "DECIMAL(20,8) comment '费用金额'")
    private BigDecimal chargesAmt;

    @Column(name = "tax_rate", columnDefinition = "DECIMAL(20,6) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "record_dtl_Id", columnDefinition = "bigint(20) comment '付款记录明细id'")
    private Long recordDtlId;

}
