package com.elitesland.fin.provider.bip.params;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 付款单.
 * <p>
 * 取值：中台储值流水（账号类型-储值账户）
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/24 周四
 */
@Getter
@Setter
public class BipFinPaymentDTO implements Serializable {
    private static final long serialVersionUID = -1135366311279758134L;

    /**
     * 公司编码
     * <p>
     * 门店的储值公司编码
     */
    @JsonProperty(value = "pk_org")
    private String ouCode;

    /**
     * 记录创建时间
     */
    @JsonProperty(value = "billdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;

    /**
     * 对象类型
     * <p>
     * 0=客户,1=供应商
     * <p>
     * 固定传：0
     */
    @JsonProperty(value = "objtype")
    private String objType;

    /**
     * 供应商编码
     * <p>
     * 不传
     */
    @JsonProperty(value = "supplier")
    private String suppCode;

    /**
     * 客户编码
     * <p>
     * 交易类型=余额扣减，则传出账公司编码（就是门店)；
     * 交易类型=余额增加，则传入账公司编码（就是门店）；
     */
    @JsonProperty(value = "customer")
    private String customerCode;

    /**
     * 付款类型
     * <p>
     * 固定传：F3-Cxx-02
     */
    @JsonProperty(value = "pk_tradetype")
    private String tradeType;

    /**
     * 结算方式
     * <p>
     * 固定传：储值账户
     */
    @JsonProperty(value = "pk_balatype")
    private String settleType;

    /**
     * 付款银行账户
     * <p>
     * 不传
     */
    @JsonProperty(value = "ap_payaccount")
    private String payAccount;

    /**
     * CBK账号
     * <p>
     * 流水的出账方账号
     */
    @JsonProperty(value = "def7")
    private String cbkAccount;

    /**
     * 币种
     * <p>
     * 固定传：CNY
     */
    @JsonProperty(value = "pk_currtype")
    private String currCode;

    /**
     * 合计金额
     */
    @JsonProperty(value = "money")
    private BigDecimal amt;

    /**
     * 汇率
     * <p>
     * 默认1
     */
    @JsonProperty(value = "rate")
    private BigDecimal currRate;

    /**
     * 合计金额(本币)
     */
    @JsonProperty(value = "local_money")
    private BigDecimal amt1;

    /**
     * 集团本币汇率
     * <p>
     * 不传值
     */
    @JsonProperty(value = "grouprate")
    private BigDecimal groupCurrRate;

    /**
     * 集团本币金额
     * <p>
     * 不传值
     */
    @JsonProperty(value = "grouplocal")
    private BigDecimal groupAmt;

    /**
     * 全局本币汇率
     * <p>
     * 不传值
     */
    @JsonProperty(value = "globalrate")
    private BigDecimal globalCurrRate;

    /**
     * 全局本币金额
     * <p>
     * 不传值
     */
    @JsonProperty(value = "globallocal")
    private BigDecimal globalAmt;

    /**
     * 制单人
     */
    @JsonProperty(value = "billmaker")
    private String creatorRoot;

    /**
     * 创建人名称
     */
    @JsonProperty(value = "def1")
    private String creator;

    /**
     * 流水号
     */
    @JsonProperty(value = "def2")
    private String docNo;

    /**
     * 备注
     */
    @JsonProperty(value = "scomment")
    private String remark;

    /**
     * 明细
     */
    @JsonProperty(value = "items")
    private List<Detail> detailList;

    @Getter
    @Setter
    public static class Detail implements Serializable {
        private static final long serialVersionUID = 529616279946831656L;

        /**
         * 付款性质
         * <p>
         * 0=应收款,1=预收款
         * <p>
         * 固定传1
         */
        @JsonProperty(value = "prepay")
        private Integer prepay;

        /**
         * 往来对象
         * <p>
         * 传编码，0=客户,1=供应商
         * <p>
         * 固定传0
         */
        @JsonProperty(value = "objtype")
        private Integer objType;

        /**
         * 供应商编码
         * <p>
         * 不传
         */
        @JsonProperty(value = "supplier")
        private String custCode;

        /**
         * 客户编码
         * <p>
         * 交易类型=余额扣减，则传出账公司编码（就是门店)；
         * 交易类型=余额增加，则传入账公司编码（就是门店）；
         */
        @JsonProperty(value = "customer")
        private String customerCode;

        /**
         * 付款业务类型
         * <p>
         * 传编码，货款/科技费/营销费/服务费
         */
        @JsonProperty(value = "pk_recpaytype")
        private String businessType;

        /**
         * 币种
         * <p>
         * 传CNY
         */
        @JsonProperty(value = "pk_currtype")
        private String currCode;

        /**
         * 金额
         */
        @JsonProperty(value = "money_de")
        private BigDecimal money;

        /**
         * 汇率
         * <p>
         * 默认1
         */
        @JsonProperty(value = "rate")
        private String currRate;

        /**
         * 金额(本币)
         */
        @JsonProperty(value = "local_money_de")
        private BigDecimal amt;

        /**
         * 集团本币汇率
         * <p>
         * 不传
         */
        @JsonProperty(value = "grouprate")
        private BigDecimal groupCurrRate;

        /**
         * 集团本币金额
         * <p>
         * 不传
         */
        @JsonProperty(value = "groupdebit")
        private BigDecimal groupAmt;

        /**
         * 集团本币汇率
         * <p>
         * 不传
         */
        @JsonProperty(value = "globalrate")
        private BigDecimal globalCurrRate;

        /**
         * 集团本币金额
         * <p>
         * 不传
         */
        @JsonProperty(value = "globaldebit")
        private BigDecimal globalAmt;

        /**
         * 贷方数量
         * <p>
         * 不传
         */
        @JsonProperty(value = "quantity_de")
        private BigDecimal qty;

        /**
         * 单价
         * <p>
         * 不传
         */
        @JsonProperty(value = "price")
        private BigDecimal price;

        /**
         * 税率编码
         * <p>
         * 不传
         */
        @JsonProperty(value = "taxcodeid")
        private String taxRateCode;

        /**
         * 合同号
         * <p>
         * 不传
         */
        @JsonProperty(value = "def1")
        private String contractNo;
    }
}
