/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.account;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.account.AccountSaveParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountSaveParam;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.dto.account.AccountRpcDTO;
import com.elitesland.fin.param.account.AccountRpcParam;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepo;
import com.elitesland.fin.service.account.AccountRpcService;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/account"})
public class AccountRpcServiceImpl
implements AccountRpcService {
    private static final Logger log = LoggerFactory.getLogger(AccountRpcServiceImpl.class);
    public final AccountService accountService;
    public final CreditAccountService creditAccountService;
    public final AccountRepo accountRepo;
    public final CreditAccountRepo creditAccountRepo;

    public ApiResult<Void> createAccount(List<AccountRpcParam> param) {
        log.info("\u5f00\u59cb\u751f\u6210\u8d26\u6237:{}", (Object)JSON.toJSONString(param));
        this.checkCreateAccountParam(param);
        this.buildAccountParam(param).stream().forEach(item -> {
            try {
                this.accountService.save((AccountSaveParam)((Object)item));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.buildCreditAccountParam(param).stream().forEach(item -> {
            try {
                this.creditAccountService.saveOrUpdate((CreditAccountSaveParam)((Object)item));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return ApiResult.ok();
    }

    private List<AccountSaveParam> buildAccountParam(List<AccountRpcParam> param) {
        List<AccountSaveParam> accountParamList = param.stream().filter(item -> UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType())).map(item -> {
            AccountSaveParam accountSaveParam = new AccountSaveParam();
            accountSaveParam.setSecOuCode(item.getOuCode());
            accountSaveParam.setAccountHolderName(item.getObjectName());
            accountSaveParam.setAccountType(item.getAccountType());
            accountSaveParam.setAccountHolderCode(item.getObjectCode());
            accountSaveParam.setAccountName(item.getAccountName());
            accountSaveParam.setAccountHolderType(item.getObjectType());
            accountSaveParam.setAccountAmount(BigDecimal.ZERO);
            accountSaveParam.setAccountOccupancyAmount(BigDecimal.ZERO);
            accountSaveParam.setAccountAvailableAmount(BigDecimal.ZERO);
            return accountSaveParam;
        }).collect(Collectors.toList());
        return accountParamList;
    }

    private List<CreditAccountSaveParam> buildCreditAccountParam(List<AccountRpcParam> param) {
        List<CreditAccountSaveParam> creditAccountSaveParamList = param.stream().filter(item -> UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType())).map(item -> {
            CreditAccountSaveParam creditAccountSaveParam = new CreditAccountSaveParam();
            creditAccountSaveParam.setOuCode(item.getOuCode());
            creditAccountSaveParam.setOuName(item.getOuName());
            creditAccountSaveParam.setObjectType(item.getObjectType());
            creditAccountSaveParam.setObjectName(item.getObjectName());
            creditAccountSaveParam.setObjectCode(item.getObjectCode());
            creditAccountSaveParam.setCreditAccountType(item.getAccountType());
            creditAccountSaveParam.setCreditAccountName(item.getAccountName());
            creditAccountSaveParam.setRelateAccountCode(item.getRelateAccountCode());
            return creditAccountSaveParam;
        }).collect(Collectors.toList());
        return creditAccountSaveParamList;
    }

    void checkCreateAccountParam(List<AccountRpcParam> accountRpcParamList) {
        Assert.notEmpty(accountRpcParamList, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        accountRpcParamList.stream().forEach(item -> {
            Assert.notEmpty((CharSequence)item.getAccountType(), (String)"\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isTrue((UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType()) ? 1 : 0) != 0, (String)"\u8d26\u6237\u7c7b\u578b\u9519\u8bef", (Object[])new Object[0]);
        });
    }

    public ApiResult<List<AccountRpcDTO>> queryAccount(AccountRpcParam accountRpcParam) {
        AccountParam accountParam = new AccountParam();
        accountParam.setSecOuCode(accountRpcParam.getOuCode());
        accountParam.setAccountHolderName(accountRpcParam.getObjectName());
        accountParam.setAccountType(accountRpcParam.getAccountType());
        accountParam.setAccountHolderCode(accountRpcParam.getObjectCode());
        accountParam.setAccountName(accountRpcParam.getAccountName());
        accountParam.setAccountHolderType(accountRpcParam.getObjectType());
        List<AccountDTO> accountDTOS = this.accountService.getAccountByAccountParam(accountParam);
        return ApiResult.ok(AccountConvert.INSTANCE.dtos2RpcDtos(accountDTOS));
    }

    @Transactional
    public ApiResult<String> updateAccountHolderName(String accountHolderCode, String accountHolderName) {
        try {
            this.accountRepo.updateAccountHolderNameByAccountHolderCode(accountHolderName, accountHolderName + "\u50a8\u503c\u8d26\u6237", accountHolderCode, "STORE");
            this.accountRepo.updateAccountHolderNameByAccountHolderCode(accountHolderName, accountHolderName + "\u8865\u8d34\u8d26\u6237", accountHolderCode, "FLZH");
            this.creditAccountRepo.updateAccountHolderNameByAccountHolderCode(accountHolderName, accountHolderName + "\u626b\u5457\u8d26\u6237", accountHolderCode, "CREDIT");
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u8d26\u6237\u540d\u79f0\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.ok();
    }

    public AccountRpcServiceImpl(AccountService accountService, CreditAccountService creditAccountService, AccountRepo accountRepo, CreditAccountRepo creditAccountRepo) {
        this.accountService = accountService;
        this.creditAccountService = creditAccountService;
        this.accountRepo = accountRepo;
        this.creditAccountRepo = creditAccountRepo;
    }
}

