package com.elitesland.fin.application.service.artype;

import com.elitesland.fin.application.convert.artype.ArTypeOuConvert;
import com.elitesland.fin.application.facade.param.artype.ArTypeOuParam;
import com.elitesland.fin.application.facade.param.artype.ArTypeOuSaveParam;
import com.elitesland.fin.application.facade.vo.artype.ArTypeOuVO;
import com.elitesland.fin.domain.entity.artype.ArTypeOu;
import com.elitesland.fin.domain.param.artype.ArTypeOuPageParam;
import com.elitesland.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.artype
 * @date 2022/4/11 17:04
 */
@Service
@RequiredArgsConstructor
public class ArTypeOuServiceImpl implements ArTypeOuService {

    private final ArTypeOuDomainService arTypeOuDomainService;

    @SysCodeProc
    @Override
    public PagingVO<ArTypeOuVO> page(ArTypeOuPageParam arTypeOuPageParam) {

        PagingVO<ArTypeOuDTO> res = arTypeOuDomainService.page(arTypeOuPageParam);
        return ArTypeOuConvert.INSTANCE.convertPage(res);
    }

    @Override
    public ApiResult<Boolean> addOu(ArTypeOuSaveParam arTypeOuSaveParam) {
        for (ArTypeOuParam arTypeOuParam : arTypeOuSaveParam.getArTypeOuParamList()) {
            ArTypeOu arTypeOu = ArTypeOuConvert.INSTANCE.convert(arTypeOuParam);
            arTypeOu.setArTypeId(arTypeOuSaveParam.getArTypeId());
            arTypeOuDomainService.addOu(arTypeOu);
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Boolean> cancelOu(List<Long> ids) {
        arTypeOuDomainService.cancelOu(ids);
        return ApiResult.ok();
    }
}
