/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.rectype;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.rectype.RecTypeConvert;
import com.elitesland.fin.application.facade.param.rectype.RecTypeSaveParam;
import com.elitesland.fin.application.facade.vo.rectype.RecTypeVO;
import com.elitesland.fin.application.service.rectype.RecTypeService;
import com.elitesland.fin.domain.entity.rectype.RecType;
import com.elitesland.fin.domain.param.rectype.RecTypePageParam;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.domain.service.rectype.RecTypeDomainService;
import com.elitesland.fin.domain.service.rectype.RecTypeOuDomainService;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.rectype.RecTypeDTO;
import com.elitesland.fin.infr.dto.rectype.RecTypeOuDTO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecTypeServiceImpl
implements RecTypeService {
    private final RecTypeDomainService recTypeDomainService;
    private final RecTypeOuDomainService recTypeOuDomainService;
    private final RecOrderDomainService recOrderDomainService;

    @Override
    public ApiResult<PagingVO<RecTypeVO>> page(RecTypePageParam param) {
        PagingVO<RecTypeDTO> page = this.recTypeDomainService.page(param);
        PagingVO<RecTypeVO> pagingVO = RecTypeConvert.INSTANCE.convertPage(page);
        return ApiResult.ok(pagingVO);
    }

    @Override
    public ApiResult<RecTypeVO> queryById(Long id) {
        RecTypeDTO recTypeDTO = this.recTypeDomainService.queryById(id);
        RecTypeVO recTypeVO = RecTypeConvert.INSTANCE.dtoToVo(recTypeDTO);
        return ApiResult.ok((Object)recTypeVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> makeDefault(Long id) {
        Long aLong = this.recTypeDomainService.makeDefault(id);
        return ApiResult.ok((Object)aLong);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> delete(List<Long> ids) {
        List<RecTypeOuDTO> recTypeOuDTOS = this.recTypeOuDomainService.queryByRecTypeIds(ids);
        Map<Long, List<RecTypeOuDTO>> typeOuDTOMap = recTypeOuDTOS.stream().collect(Collectors.groupingBy(RecTypeOuDTO::getRecTypeId));
        Map<Long, List<RecOrderDTO>> orderMap = this.recOrderDomainService.queryByRecTypeId(ids).stream().collect(Collectors.groupingBy(RecOrderDTO::getRecTypeId));
        for (Map.Entry<Long, List<RecTypeOuDTO>> entry : typeOuDTOMap.entrySet()) {
            if (entry.getValue() == null || !CollUtil.isNotEmpty((Collection)entry.getValue())) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u6570\u636e\u5df2\u5206\u914d\u516c\u53f8!");
        }
        for (Map.Entry<Long, List<Serializable>> entry : orderMap.entrySet()) {
            if (entry.getValue() == null || !CollUtil.isNotEmpty((Collection)entry.getValue())) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u6570\u636e\u5df2\u5173\u8054\u6536\u6b3e\u5355!");
        }
        return ApiResult.ok(this.recTypeDomainService.delete(ids));
    }

    @Override
    public ApiResult<List<RecTypeVO>> findAll() {
        List<RecTypeDTO> all = this.recTypeDomainService.findAll();
        List<RecTypeVO> recTypeVOS = RecTypeConvert.INSTANCE.dtoToVo(all);
        return ApiResult.ok(recTypeVOS);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> enable(List<Long> ids) {
        List<RecTypeOuDTO> recTypeOuDTOS = this.recTypeOuDomainService.queryByRecTypeIds(ids);
        Map<Long, RecTypeDTO> dtoMap = this.recTypeDomainService.queryByIds(ids).stream().collect(Collectors.toMap(RecTypeDTO::getId, t -> t));
        Map<Long, List<RecTypeOuDTO>> ouMap = recTypeOuDTOS.stream().collect(Collectors.groupingBy(RecTypeOuDTO::getRecTypeId));
        if (CollUtil.isEmpty(ouMap)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u5206\u914d\u516c\u53f8\u4fe1\u606f,\u8bf7\u5206\u914d\u540e\u518d\u542f\u7528");
        }
        RecTypeServiceImpl.check(dtoMap, ouMap);
        return ApiResult.ok(this.recTypeDomainService.enable(ids));
    }

    private static void check(Map<Long, RecTypeDTO> dtoMap, Map<Long, List<RecTypeOuDTO>> ouMap) {
        for (Map.Entry<Long, List<RecTypeOuDTO>> entry : ouMap.entrySet()) {
            if (entry.getValue() != null && dtoMap.get(entry.getKey()) != null && CollUtil.isEmpty((Collection)entry.getValue())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7c7b\u578b\u4ee3\u7801" + dtoMap.get(entry.getKey()).getRecTypeCode() + "\u542f\u7528\u524d\u9700\u8981\u5206\u914d\u516c\u53f8");
            }
            if (dtoMap.get(entry.getKey()) == null || !dtoMap.get(entry.getKey()).getEnableFlag().booleanValue()) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u542f\u7528\u72b6\u6001\u4e0d\u5141\u8bb8\u518d\u6b21\u542f\u7528");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> stopEnable(List<Long> ids) {
        return ApiResult.ok(this.recTypeDomainService.stopEnable(ids));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(RecTypeSaveParam param) {
        RecType recType = RecTypeConvert.INSTANCE.convert(param);
        Long id = this.recTypeDomainService.save(recType);
        return ApiResult.ok((Object)id);
    }

    public RecTypeServiceImpl(RecTypeDomainService recTypeDomainService, RecTypeOuDomainService recTypeOuDomainService, RecOrderDomainService recOrderDomainService) {
        this.recTypeDomainService = recTypeDomainService;
        this.recTypeOuDomainService = recTypeOuDomainService;
        this.recOrderDomainService = recOrderDomainService;
    }
}

