package com.elitesland.fin.domain.service.saleinvd;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedApplyResult;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDetailAppVO;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.domain.param.saleinvd.SaleInvdParam;
import com.elitesland.fin.domain.service.invoice.InvoiceRuleConfigDomainService;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.saleinv
 * @date 2022/5/6 17:00
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SaleInvdDomainServiceImpl implements SaleInvdDomainService {

    public final SaleInvdDtlRepoProc saleInvdDtlRepoProc;
    public final SaleInvdDtlRepo saleInvdDtlRepo;
    public final InvoiceRuleConfigDomainService invoiceRuleConfigDomainService;
    public final SaleInvRepo saleInvRepo;
    private final InvoiceAwaitService invoiceAwaitService;
    private final InvoiceService invoiceService;

    @Override
    @Transactional
    public void cancel(Long id) {
        Assert.notNull(id, "id必填");

        SaleInvdDtlDO saleInvdDtlDO = querySaleInvdDtlDOById(id);

        Assert.equals(saleInvdDtlDO.getInvState(), UdcEnum.INV_STATE_SUCCESS.getValueCode(), "只有开票状态为开票成功才能作废");
        Assert.equals(saleInvdDtlDO.getRedState(), UdcEnum.RED_STATE_NO.getValueCode(), "只有红冲状态为未红冲才能作废");

        saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_CANCEL_SUCCESS.getValueCode());
    }

    @Override
    @Transactional
    public void red(Long id) {
        Assert.notNull(id, "id必填");

        SaleInvdDtlDO saleInvdDtlDO = querySaleInvdDtlDOById(id);

        Assert.equals(saleInvdDtlDO.getInvState(), UdcEnum.INV_STATE_SUCCESS.getValueCode(), "只有开票状态为开票成功才能红冲");
        if (!Objects.equals(saleInvdDtlDO.getRedState(), UdcEnum.RED_STATE_NO.getValueCode()) && !Objects.equals(saleInvdDtlDO.getRedState(), UdcEnum.RED_STATE_FAIL.getValueCode())) {
            throw new BusinessException("只有红冲状态为未红冲或者红冲失败才能红冲");
        }

        InvoiceRuleConfigQueryParam invoiceRuleConfigQueryParam = new InvoiceRuleConfigQueryParam();
        SaleInvDO saleInvDO = querySaleInvDOById(saleInvdDtlDO.getMasId());
        invoiceRuleConfigQueryParam.setOptDocCls(saleInvDO.getCreateMode());
        // 组装红冲接口入参
        InvoiceRedApplySaveParam saveParam = new InvoiceRedApplySaveParam();
        saveParam.setOriginApplyNo(saleInvDO.getApplyNo());
        saveParam.setSaleTaxNo(saleInvDO.getSaleTaxNo());
        saveParam.setCustTaxNo(saleInvDO.getCustTaxNo());
        saveParam.setInvType(saleInvDO.getInvType());
        saveParam.setInvDate(saleInvdDtlDO.getInvDate());
        saveParam.setInvNo(saleInvdDtlDO.getInvNo());
        // 红票申请
        InvoiceRedApplyResult invoiceRedApplyResult = new InvoiceRedApplyResult();
        try {
            invoiceRedApplyResult = invoiceService.redInvoice(saveParam);
        } catch (Exception e) {
            log.error("红票申请失败:{}", e.getMessage(), e);
            invoiceRedApplyResult.setRedFailCause(e.getMessage());
        }

        List<SaleInvdDtlDO> saleInvSaveList = new ArrayList<>();
        if (invoiceRedApplyResult.getRedFailCause() == null) {
            // 审批通过且红冲成功，生成开票申请单
            saleInvdDtlDO.setRedState(UdcEnum.RED_STATE_SUCCESS.getValueCode());
            saleInvdDtlDO.setRedFailCause(null);
            saleInvdDtlDO.setInvoiceRedraftState(null);
            if (invoiceRedApplyResult.getRedInvoiceInitData() != null) {
                saleInvdDtlDO.setRedOriginalContent(JSON.toJSONString(invoiceRedApplyResult.getRedInvoiceInitData()));
            }
            saleInvSaveList.add(saleInvdDtlDO);

            // 更新待开发票以及对账单发票状态为红冲
            SaleInvStatusParam statusParam = new SaleInvStatusParam();
            statusParam.setApplyNoList(List.of(saleInvDO.getApplyNo()));
            statusParam.setInvState(UdcEnum.RED_STATE_SUCCESS.getValueCode());
            invoiceAwaitService.updateRedState(statusParam);

            SaleInvdDtlDO redSaleInvdDtlDO = new SaleInvdDtlDO();
            redSaleInvdDtlDO.setBlueInvNo(saleInvdDtlDO.getInvNo());
            redSaleInvdDtlDO.setMasId(saleInvdDtlDO.getMasId());
            redSaleInvdDtlDO.setInvNo(invoiceRedApplyResult.getRedInvoiceNo());
            redSaleInvdDtlDO.setSaleTaxNo(saleInvdDtlDO.getSaleTaxNo());
            redSaleInvdDtlDO.setRedState(null);
            // 负数
            redSaleInvdDtlDO.setTotalAmt(saleInvdDtlDO.getTotalAmt().multiply(new BigDecimal(-1)));
            redSaleInvdDtlDO.setInvState(UdcEnum.INV_STATE_ING.getValueCode());
            redSaleInvdDtlDO.setInvDate(LocalDateTime.now());
            redSaleInvdDtlDO.setRedBlueType(UdcEnum.INV_RED_BLUE_TYPE_RED.getValueCode());

            redSaleInvdDtlDO.setInvCode(invoiceRedApplyResult.getRedInvoiceConfirmNo());
            redSaleInvdDtlDO.setCheckCode(invoiceRedApplyResult.getUuid());

            if (invoiceRedApplyResult.getRedInvoiceInitData() != null) {
                redSaleInvdDtlDO.setRedOriginalContent(JSON.toJSONString(invoiceRedApplyResult.getRedInvoiceInitData()));
            }
            saleInvSaveList.add(redSaleInvdDtlDO);
        } else {
            saleInvdDtlDO.setRedState(UdcEnum.RED_STATE_FAIL.getValueCode());
            saleInvdDtlDO.setRedFailCause(invoiceRedApplyResult.getRedFailCause());
            if (invoiceRedApplyResult.getRedInvoiceInitData() != null) {
                saleInvdDtlDO.setRedOriginalContent(JSON.toJSONString(invoiceRedApplyResult.getRedInvoiceInitData()));
            }
            saleInvSaveList.add(saleInvdDtlDO);
        }

        if (CollectionUtil.isNotEmpty(saleInvSaveList)) {
            saleInvdDtlRepo.saveAll(saleInvSaveList);
        }
    }

    @Override
    public InvoiceRedraftPageVO redraft(Long id) {
        Assert.notNull(id, "id必填");

        SaleInvdDtlDO saleInvdDtlDO = querySaleInvdDtlDOById(id);
        Assert.equals(saleInvdDtlDO.getInvState(), UdcEnum.INV_STATE_SUCCESS.getValueCode(), "只有开票状态为开票成功才能提交换开申请");
        Assert.equals(saleInvdDtlDO.getRedState(), UdcEnum.RED_STATE_SUCCESS.getValueCode(), "只有红冲状态为已红冲才能提交换开申请");

        //获取开票设置
        List<InvoiceRuleConfigQueryParam> invoiceRuleConfigQueryParamList = new ArrayList<>();
        InvoiceRuleConfigQueryParam invoiceRuleConfigQueryParam = new InvoiceRuleConfigQueryParam();

        SaleInvDO saleInvDO = querySaleInvDOById(saleInvdDtlDO.getMasId());

        invoiceRuleConfigQueryParam.setOptDocCls(saleInvDO.getCreateMode());
        invoiceRuleConfigQueryParamList.add(invoiceRuleConfigQueryParam);
        List<InvoiceRuleConfigDTO> invoiceRuleConfigDTOList = invoiceRuleConfigDomainService.getRuleConfigList(invoiceRuleConfigQueryParamList);
        Assert.notEmpty(invoiceRuleConfigDTOList, "来源单据匹配不到开票设置");

        boolean flag = true;
        for (InvoiceRuleConfigDTO invoiceRuleConfigDTO : invoiceRuleConfigDTOList) {
            if (invoiceRuleConfigDTO.getNeedRedraft() == 0) {
                flag = false;
                break;
            }
        }
        Assert.isTrue(flag, "来源单据无需提交换开申请");

        //需要提交换开申请，校验销售已开发票明细是否已经申请换开/已经审批通过
        if (UdcEnum.APPLY_STATUS_DOING.getValueCode().equals(saleInvdDtlDO.getInvoiceRedraftState())) {
            throw new BusinessException("换开申请审批中");
        }

        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(saleInvdDtlDO.getInvoiceRedraftState())) {
            throw new BusinessException("换开申请已审批通过");
        }

        // 申请单的明细行数据
        SaleInvDTO saleInvDTO = SaleInvConvert.INSTANCE.saleInvDO2SaleInvDTO(saleInvDO);

        return buildInvoiceRedraft(saleInvDTO, saleInvdDtlDO);
    }


    private InvoiceRedraftPageVO buildInvoiceRedraft(SaleInvDTO saleInvDTO, SaleInvdDtlDO saleInvdDtlDO) {

        InvoiceRedraftPageVO invoiceRedraftPageVO = new InvoiceRedraftPageVO();
        invoiceRedraftPageVO.setInvoiceNo(saleInvdDtlDO.getInvNo());
        invoiceRedraftPageVO.setSerialNo(saleInvdDtlDO.getFlowNo());
        invoiceRedraftPageVO.setInvoiceAmt(saleInvdDtlDO.getTotalAmt());
        invoiceRedraftPageVO.setInvoiceDate(saleInvdDtlDO.getInvDate());
        invoiceRedraftPageVO.setInvoiceType(saleInvDTO.getInvType());

        return invoiceRedraftPageVO;

    }

    private SaleInvDO querySaleInvDOById(Long id) {
        List<SaleInvDO> saleInvDOList = saleInvRepo.findAllById(id);
        Assert.isTrue(saleInvDOList.size() == 1, "根据id不到数据/查到多条数据");
        SaleInvDO saleInvDO = saleInvDOList.get(0);
        return saleInvDO;
    }

    private SaleInvdDtlDO querySaleInvdDtlDOById(Long id) {
        List<SaleInvdDtlDO> saleInvdDtlDOList = saleInvdDtlRepo.findAllById(id);
        Assert.isTrue(saleInvdDtlDOList.size() == 1, "根据id不到数据/查到多条数据");
        return saleInvdDtlDOList.get(0);
    }

    private SaleInvdDtlDO querySaleInvdDtlDOByInvoiceNo(String invoiceNo) {
        List<SaleInvdDtlDO> saleInvdDtlDOList = saleInvdDtlRepo.findAllByInvNo(invoiceNo);
        Assert.isTrue(saleInvdDtlDOList.size() == 1, "根据id不到数据/查到多条数据");
        return saleInvdDtlDOList.get(0);
    }

    @Override
    @Transactional
    public void update(SaleInvdParam param) {
        Assert.notNull(param.getInvoiceNo(),"发票号码必填");
        Assert.notNull(param.getInvoiceRedraftState(),"换开审核状态必填");

        SaleInvdDtlDO saleInvdDtlDO = querySaleInvdDtlDOByInvoiceNo(param.getInvoiceNo());
        saleInvdDtlDO.setInvoiceRedraftState(param.getInvoiceRedraftState());
    }

    @Override
    public SaleInvDetailAppVO appGet(Long id) {
        return saleInvdDtlRepoProc.appGet(id);
    }
}
