package com.elitesland.fin.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.commons.lang.StringUtils;

import java.util.concurrent.TimeUnit;

public class SysUtils {

    private static final String TECHNOLOGY_COSTS = "TECHNOLOGY_COSTS";
    private static final String OPERATING_COSTS = "OPERATING_COSTS";
    private static final String MARKETING_COSTS = "MARKETING_COSTS";

    private static Cache<String, String> orderSettingCache = Caffeine.newBuilder().maximumSize(5).expireAfterWrite(8, TimeUnit.HOURS).build();
    /**
     * 调用系统域，获取单价小数位数
     */
    public static Integer getPricePlace() {
        SysSettingVO priceDecimalPlace = SpringUtil.getBean(SystemRpcService.class).findSysSettingByNo("PRICE_DECIMAL_PLACE");
        if (priceDecimalPlace == null) {
            throw new BusinessException("调用系统域报错：获取单价小数位数报错");
        }

        String settingVal = priceDecimalPlace.getSettingVal();
        if (StringUtils.isBlank(settingVal)) {
            throw new BusinessException("调用系统域报错：未设置单价小数");
        }

        try {
            return Integer.parseInt(settingVal.trim());
        } catch (Exception e) {
            throw new BusinessException("调用系统域报错：单价小数位不是数字" + e.getMessage());
        }
    }

    /**
     * 调用系统域，获取金额小数位数
     */
    public static Integer getAmtPlace() {
        SysSettingVO amountDecimalPlace = SpringUtil.getBean(SystemRpcService.class).findSysSettingByNo("AMOUNT_DECIMAL_PLACE");
        if (amountDecimalPlace == null) {
            throw new BusinessException("调用系统域报错：获取金额小数位数报错");
        }

        String settingVal = amountDecimalPlace.getSettingVal();
        if (StringUtils.isBlank(settingVal)) {
            throw new BusinessException("调用系统域报错：未设置金额小数");
        }

        try {
            return Integer.parseInt(settingVal.trim());
        } catch (Exception e) {
            throw new BusinessException("调用系统域报错：金额小数位不是数字" + e.getMessage());
        }
    }

    public static String getOptType(String sourceDocStatus) {
        if (FinConstant.ACCOUNT_FLOW_TYPE_PAY.contains(sourceDocStatus)) {
            return UdcEnum.FLOW_OPT_TYPE_PAY.getValueCode();
        } else if (FinConstant.ACCOUNT_FLOW_TYPE_RETURN.contains(sourceDocStatus)) {
            return UdcEnum.FLOW_OPT_TYPE_RETURN.getValueCode();
        } else if (FinConstant.ACCOUNT_FLOW_TYPE_REFUND.contains(sourceDocStatus)) {
            return UdcEnum.FLOW_OPT_TYPE_REFUND.getValueCode();
        } else if (FinConstant.ACCOUNT_FLOW_TYPE_CLOSE.contains(sourceDocStatus)) {
            return UdcEnum.FLOW_OPT_TYPE_CLOSE.getValueCode();
        } else if (FinConstant.ACCOUNT_FLOW_TYPE_AO_ALL.contains(sourceDocStatus)) {
            return UdcEnum.FLOW_OPT_TYPE_AO.getValueCode();
        } else {
            return null;
        }
    }

    public static String getTechnologyCosts() {
        return orderSettingCache.get(TECHNOLOGY_COSTS, key -> {
            SysSettingVO orderSetting = SpringUtil.getBean(SystemRpcService.class).findSysSettingByNo(TECHNOLOGY_COSTS);
            return (orderSetting == null || StrUtil.isBlank(orderSetting.getSettingVal())) ? "1" : orderSetting.getSettingVal().trim();
        });
    }

    public static String getOperatingCosts() {
        return orderSettingCache.get(OPERATING_COSTS, key -> {
            SysSettingVO orderSetting = SpringUtil.getBean(SystemRpcService.class).findSysSettingByNo(OPERATING_COSTS);
            return (orderSetting == null || StrUtil.isBlank(orderSetting.getSettingVal())) ? "1" : orderSetting.getSettingVal().trim();
        });
    }
    public static String getMarketingCosts() {
        return orderSettingCache.get(MARKETING_COSTS, key -> {
            SysSettingVO orderSetting = SpringUtil.getBean(SystemRpcService.class).findSysSettingByNo(MARKETING_COSTS);
            return (orderSetting == null || StrUtil.isBlank(orderSetting.getSettingVal())) ? "1" : orderSetting.getSettingVal().trim();
        });
    }
}
