/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.saobei;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.param.saobei.param.SaobeiAccountInParamVO;
import com.elitesland.fin.application.facade.param.saobei.param.SaobeiAccountRuleParamVO;
import com.elitesland.fin.application.facade.param.saobei.param.SaobeiCenterlinkParamVO;
import com.elitesland.fin.application.facade.param.saobei.param.SaobeiDoTransRequestParam;
import com.elitesland.fin.application.facade.param.saobei.param.SaobeiTradeParamVO;
import com.elitesland.fin.application.facade.param.saobei.vo.SaobeiAccountDetailVO;
import com.elitesland.fin.application.facade.param.saobei.vo.SaobeiBalanceDetailVO;
import com.elitesland.fin.application.facade.param.saobei.vo.SaobeiCenterlinkRespVO;
import com.elitesland.fin.application.facade.param.saobei.vo.SaobeiTradeRespVO;
import com.elitesland.fin.application.facade.param.saobei.vo.SaobeiTransRespVO;
import com.elitesland.fin.application.service.saobei.SaobeiAccountService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.config.SaoBeiProperties;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepo;
import com.elitesland.fin.repo.flow.AccountFlowRepo;
import com.saobei.open.sdk.model.requst.allocate.SaobeiAccountAuthenticationRequest;
import com.saobei.open.sdk.model.requst.allocate.SaobeiAccountInQueryRequest;
import com.saobei.open.sdk.model.requst.allocate.SaobeiAccountUpdateRequest;
import com.saobei.open.sdk.model.requst.allocate.SaobeiDoTransRequest;
import com.saobei.open.sdk.model.requst.allocate.SaobeiQueryBalanceRequest;
import com.saobei.open.sdk.model.requst.allocate.SaobeiQueryOrderRequest;
import com.saobei.open.sdk.model.response.allocate.SaobeiAccountAuthenticationResponse;
import com.saobei.open.sdk.model.response.allocate.SaobeiAccountInAddResponse;
import com.saobei.open.sdk.model.response.allocate.SaobeiAccountInQueryResponse;
import com.saobei.open.sdk.model.response.allocate.SaobeiAccountQueryResponse;
import com.saobei.open.sdk.model.response.allocate.SaobeiAccountUpdateResponse;
import com.saobei.open.sdk.model.response.allocate.SaobeiDoTransResponse;
import com.saobei.open.sdk.model.response.allocate.SaobeiQueryOrderResponse;
import com.saobei.open.sdk.util.ApiUtil;
import com.saobei.open.sdk.util.HttpClientUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.UUID;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SaobeiAccountServiceImpl
implements SaobeiAccountService {
    private static final Logger log = LoggerFactory.getLogger(SaobeiAccountServiceImpl.class);
    private final SaoBeiProperties saoBeiProperties;
    private final AccountFlowRepo accountFlowRepo;
    private final CreditAccountFlowRepo creditAccountFlowRepo;

    @Override
    public SaobeiAccountInAddResponse addAccountIn(String accountNoOut, String accountNoIn, Integer allocateScale) throws Exception {
        SaobeiAccountInParamVO accountInAddRequest = new SaobeiAccountInParamVO();
        accountInAddRequest.setInst_no(this.saoBeiProperties.getInstNo());
        accountInAddRequest.setApi_ver(this.saoBeiProperties.getApiVer());
        accountInAddRequest.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        accountInAddRequest.setAccount_no_out(accountNoOut);
        accountInAddRequest.setContract_type("1");
        accountInAddRequest.setRelation_type("1");
        SaobeiAccountRuleParamVO saobeiAccountRuleParamVO = new SaobeiAccountRuleParamVO();
        saobeiAccountRuleParamVO.setAccount_no_in(accountNoIn);
        saobeiAccountRuleParamVO.setAllocate_scale(allocateScale);
        accountInAddRequest.setAccount_rule(JSON.toJSONString((Object)saobeiAccountRuleParamVO));
        JSONObject obj = ApiUtil.convertRequest((Object)accountInAddRequest, (String)this.saoBeiProperties.getInstkey(), (String)"key");
        String jsonString = JSON.toJSONString((Object)obj);
        log.info("\u626b\u5457\u6dfb\u52a0\u5206\u8d26\u5173\u7cfb\u62a5\u6587:{}", (Object)jsonString);
        String responseStr = HttpClientUtil.post((String)(this.saoBeiProperties.getMchServerUrl() + this.saoBeiProperties.getAddAccountInPath()), (String)jsonString, (int)8000, (String)"application/json", (String)"utf-8");
        log.info("\u626b\u5457\u6dfb\u52a0\u5206\u8d26\u5173\u7cfb\u8fd4\u56de\u62a5\u6587: {}", (Object)responseStr);
        SaobeiAccountInAddResponse response = (SaobeiAccountInAddResponse)JSON.parseObject((String)responseStr, SaobeiAccountInAddResponse.class);
        if (response == null) {
            throw new BusinessException("\u626b\u5457\u6dfb\u52a0\u5206\u8d26\u5173\u7cfb\u54cd\u5e94\u4e3a\u7a7a");
        }
        return response;
    }

    @Override
    public SaobeiAccountAuthenticationResponse accountAuthentication(SaobeiAccountAuthenticationRequest paramVO) throws Exception {
        paramVO.setInst_no(this.saoBeiProperties.getInstNo());
        paramVO.setApi_ver(this.saoBeiProperties.getApiVer());
        paramVO.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest((Object)paramVO, (String)this.saoBeiProperties.getInstkey(), (String)"key");
        String jsonString = JSON.toJSONString((Object)obj);
        log.info("\u626b\u5457CBK\u8d26\u6237\u9274\u6743\u62a5\u6587:{}", (Object)jsonString);
        String responseStr = HttpClientUtil.post((String)(this.saoBeiProperties.getMchServerUrl() + this.saoBeiProperties.getAccountAuthenticationPath()), (String)jsonString, (int)8000, (String)"application/json", (String)"utf-8");
        log.info("\u626b\u5457CBK\u8d26\u6237\u9274\u6743\u8fd4\u56de\u62a5\u6587: {}", (Object)responseStr);
        SaobeiAccountAuthenticationResponse response = (SaobeiAccountAuthenticationResponse)JSON.parseObject((String)responseStr, SaobeiAccountAuthenticationResponse.class);
        if (response == null) {
            throw new BusinessException("\u626b\u5457CBK\u8d26\u6237\u9274\u6743\u54cd\u5e94\u4e3a\u7a7a");
        }
        return response;
    }

    @Override
    public SaobeiAccountQueryResponse queryAccount(SaobeiAccountAuthenticationRequest paramVO) throws Exception {
        String responseStr = this.saoBeiQueryAccount(paramVO);
        SaobeiAccountQueryResponse response = (SaobeiAccountQueryResponse)JSON.parseObject((String)responseStr, SaobeiAccountQueryResponse.class);
        if (response == null) {
            throw new BusinessException("\u626b\u5457CBK\u8d26\u6237\u67e5\u8be2\u54cd\u5e94\u4e3a\u7a7a");
        }
        return response;
    }

    @Override
    public SaobeiAccountDetailVO queryAccountDetail(SaobeiAccountAuthenticationRequest paramVO) throws Exception {
        String responseStr = this.saoBeiQueryAccount(paramVO);
        SaobeiAccountDetailVO response = (SaobeiAccountDetailVO)JSON.parseObject((String)responseStr, SaobeiAccountDetailVO.class);
        if (response == null) {
            throw new BusinessException("\u626b\u5457CBK\u8d26\u6237\u67e5\u8be2\u54cd\u5e94\u4e3a\u7a7a");
        }
        return response;
    }

    private String saoBeiQueryAccount(SaobeiAccountAuthenticationRequest paramVO) throws Exception {
        paramVO.setInst_no(this.saoBeiProperties.getInstNo());
        paramVO.setApi_ver(this.saoBeiProperties.getQueryAccountApiVer());
        paramVO.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest((Object)paramVO, (String)this.saoBeiProperties.getInstkey(), (String)"key");
        String jsonString = JSON.toJSONString((Object)obj);
        log.info("\u626b\u5457CBK\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u62a5\u6587:{}", (Object)jsonString);
        String responseStr = HttpClientUtil.post((String)(this.saoBeiProperties.getMchServerUrl() + this.saoBeiProperties.getQueryAccountPath()), (String)jsonString, (int)8000, (String)"application/json", (String)"utf-8");
        log.info("\u626b\u5457CBK\u8d26\u6237\u4fe1\u606f\u8fd4\u56de\u62a5\u6587: {}", (Object)responseStr);
        return responseStr;
    }

    @Override
    public SaobeiAccountInQueryResponse queryAccountIn(SaobeiAccountInQueryRequest paramVO) throws Exception {
        paramVO.setInst_no(this.saoBeiProperties.getInstNo());
        paramVO.setApi_ver(this.saoBeiProperties.getApiVer());
        paramVO.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest((Object)paramVO, (String)this.saoBeiProperties.getInstkey(), (String)"key");
        String jsonString = JSON.toJSONString((Object)obj);
        log.info("\u626b\u5457\u5206\u8d26\u5173\u7cfb\u67e5\u8be2\u62a5\u6587:{}", (Object)jsonString);
        String responseStr = HttpClientUtil.post((String)(this.saoBeiProperties.getMchServerUrl() + this.saoBeiProperties.getAccountInQueryPath()), (String)jsonString, (int)8000, (String)"application/json", (String)"utf-8");
        log.info("\u626b\u5457\u5206\u8d26\u5173\u7cfb\u67e5\u8be2\u8fd4\u56de\u62a5\u6587: {}", (Object)responseStr);
        SaobeiAccountInQueryResponse response = (SaobeiAccountInQueryResponse)JSON.parseObject((String)responseStr, SaobeiAccountInQueryResponse.class);
        if (response == null) {
            throw new BusinessException("\u626b\u5457\u5206\u8d26\u5173\u7cfb\u67e5\u8be2\u54cd\u5e94\u4e3a\u7a7a");
        }
        return response;
    }

    @Override
    public SaobeiTradeRespVO queryTradesByDate(SaobeiTradeParamVO paramVO) throws Exception {
        paramVO.setInst_no(this.saoBeiProperties.getInstNo());
        paramVO.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        paramVO.setApi_ver(this.saoBeiProperties.getApiVer());
        JSONObject obj = ApiUtil.convertRequest((Object)paramVO, (String)this.saoBeiProperties.getInstkey(), (String)"key");
        String jsonString = JSON.toJSONString((Object)obj);
        log.info("\u8bf7\u6c42\u5206\u8d26\u6570\u636e\u5217\u8868\u67e5\u8be2\u62a5\u6587:{}", (Object)jsonString);
        String responseStr = HttpClientUtil.post((String)(this.saoBeiProperties.getMchServerUrl() + this.saoBeiProperties.getQueryTradesByDatePath()), (String)jsonString, (int)8000, (String)"application/json", (String)"utf-8");
        log.info("\u626b\u5457\u5206\u8d26\u6570\u636e\u5217\u8868\u67e5\u8be2\u8fd4\u56de\u62a5\u6587: {}", (Object)responseStr);
        SaobeiTradeRespVO response = (SaobeiTradeRespVO)JSON.parseObject((String)responseStr, SaobeiTradeRespVO.class);
        if ("01".equals(response.getReturn_code()) && "01".equals(response.getResult_code())) {
            return response;
        }
        throw new BusinessException("\u67e5\u8be2\u5206\u5e10\u6570\u636e\u5931\u8d25:" + response.getReturn_msg());
    }

    @Override
    public SaobeiAccountUpdateResponse updateAccount(SaobeiAccountUpdateRequest request) throws Exception {
        request.setApi_ver(this.saoBeiProperties.getApiVer());
        request.setInst_no(this.saoBeiProperties.getInstNo());
        request.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest((Object)request, (String)this.saoBeiProperties.getInstkey(), (String)"key");
        String jsonString = JSON.toJSONString((Object)obj);
        log.info("\u626b\u5457\u66f4\u65b0\u7ed3\u7b97\u4fe1\u606f\u62a5\u6587:{}", (Object)jsonString);
        String responseStr = HttpClientUtil.post((String)(this.saoBeiProperties.getMchServerUrl() + this.saoBeiProperties.getUpdateAccountUrl()), (String)jsonString, (int)8000, (String)"application/json", (String)"utf-8");
        log.info("\u626b\u5457\u66f4\u65b0\u7ed3\u7b97\u4fe1\u606f\u8fd4\u56de\u62a5\u6587: {}", (Object)responseStr);
        return (SaobeiAccountUpdateResponse)JSON.parseObject((String)responseStr, SaobeiAccountUpdateResponse.class);
    }

    @Override
    public String centerlink(String accountNo) throws Exception {
        SaobeiCenterlinkParamVO saobeiCenterlinkParamVO = new SaobeiCenterlinkParamVO();
        saobeiCenterlinkParamVO.setAccount_no(accountNo);
        saobeiCenterlinkParamVO.setInst_no(this.saoBeiProperties.getInstNo());
        saobeiCenterlinkParamVO.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        saobeiCenterlinkParamVO.setApi_ver(this.saoBeiProperties.getApiVer());
        JSONObject obj = ApiUtil.convertRequest((Object)saobeiCenterlinkParamVO, (String)this.saoBeiProperties.getInstkey(), (String)"key");
        String jsonString = JSON.toJSONString((Object)obj);
        log.info("\u8bf7\u6c42\u626b\u5457\u4f1a\u5458\u4e2d\u5fc3\u62a5\u6587:{}", (Object)jsonString);
        String responseStr = HttpClientUtil.post((String)(this.saoBeiProperties.getCenterServerUrl() + this.saoBeiProperties.getCenterPath()), (String)jsonString, (int)8000, (String)"application/json", (String)"utf-8");
        log.info("\u626b\u5457\u4f1a\u5458\u4e2d\u5fc3\u8fd4\u56de\u62a5\u6587: {}", (Object)responseStr);
        SaobeiCenterlinkRespVO response = (SaobeiCenterlinkRespVO)JSON.parseObject((String)responseStr, SaobeiCenterlinkRespVO.class);
        if ("01".equals(response.getReturn_code())) {
            return response.getAccount_center_url();
        }
        String errorMsg = response.getReturn_msg();
        log.error("\u626b\u5457\u4f1a\u5458\u4e2d\u5fc3\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)errorMsg);
        throw new BusinessException(errorMsg);
    }

    @Override
    public String getBalance(String accountNo) throws Exception {
        SaobeiQueryBalanceRequest saobeiQueryBalanceRequest = new SaobeiQueryBalanceRequest();
        saobeiQueryBalanceRequest.setAccount_no(accountNo);
        saobeiQueryBalanceRequest.setInst_no(this.saoBeiProperties.getInstNo());
        saobeiQueryBalanceRequest.setApi_ver("102");
        saobeiQueryBalanceRequest.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest((Object)saobeiQueryBalanceRequest, (String)this.saoBeiProperties.getInstkey(), (String)"key");
        String jsonString = JSON.toJSONString((Object)obj);
        log.info("\u626b\u5457\u67e5\u8be2CBK\u8d26\u6237\u4f59\u989d\u62a5\u6587:{}", (Object)jsonString);
        String responseStr = HttpClientUtil.post((String)(this.saoBeiProperties.getMchServerUrl() + this.saoBeiProperties.getAccountBalancePath()), (String)jsonString, (int)2000, (String)"application/json", (String)"utf-8");
        log.info("\u626b\u5457\u67e5\u8be2CBK\u8d26\u6237\u4f59\u989d\u8fd4\u56de\u62a5\u6587: {}", (Object)responseStr);
        SaobeiBalanceDetailVO response = (SaobeiBalanceDetailVO)JSON.parseObject((String)responseStr, SaobeiBalanceDetailVO.class);
        if (response == null) {
            throw new BusinessException("\u67e5\u8be2CBK\u8d26\u6237\u4f59\u989d\u54cd\u5e94\u4e3a\u7a7a");
        }
        if ("01".equals(response.getReturn_code())) {
            String available = response.getAvailable_bal() == null ? "0.00" : response.getAvailable_bal();
            String recharge = response.getRecharge_dedicated_amt() == null ? "0.00" : response.getRecharge_dedicated_amt();
            return new BigDecimal(available).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP).add(new BigDecimal(recharge).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP)).toString();
        }
        String errorMsg = response.getReturn_msg();
        log.error("\u626b\u5457\u67e5\u8be2CBK\u8d26\u6237\u4f59\u989d\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)errorMsg);
        return "0.00";
    }

    @Override
    public SaobeiDoTransResponse dotrans(SaobeiDoTransRequest request) throws Exception {
        request.setApi_ver(this.saoBeiProperties.getApiVer());
        request.setInst_no(this.saoBeiProperties.getInstNo());
        request.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest((Object)request, (String)this.saoBeiProperties.getInstkey(), (String)"key");
        String jsonString = JSON.toJSONString((Object)obj);
        log.info("\u626b\u5457CBK\u4f59\u989d\u5206\u8d26\u62a5\u6587:{}", (Object)jsonString);
        String responseStr = HttpClientUtil.post((String)(this.saoBeiProperties.getMchServerUrl() + this.saoBeiProperties.getAccountTransPath()), (String)jsonString, (int)2000, (String)"application/json", (String)"utf-8");
        log.info("\u626b\u5457CBK\u4f59\u989d\u5206\u8d26\u8fd4\u56de\u62a5\u6587: {}", (Object)responseStr);
        return (SaobeiDoTransResponse)JSON.parseObject((String)responseStr, SaobeiDoTransResponse.class);
    }

    @Override
    public SaobeiTransRespVO doAlltrans(SaobeiDoTransRequestParam request) throws Exception {
        request.setApi_ver(this.saoBeiProperties.getApiVer());
        request.setInst_no(this.saoBeiProperties.getInstNo());
        request.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        if (Strings.isNotBlank((String)this.saoBeiProperties.getSceneNo())) {
            request.setScene_no(this.saoBeiProperties.getSceneNo());
        }
        JSONObject obj = ApiUtil.convertRequest((Object)((Object)request), (String)this.saoBeiProperties.getInstkey(), (String)"key");
        String jsonString = JSON.toJSONString((Object)obj);
        log.info("\u626b\u5457CBK\u4f59\u989d\u5206\u8d26\u62a5\u6587:{}", (Object)jsonString);
        String responseStr = HttpClientUtil.post((String)(this.saoBeiProperties.getMchServerUrl() + this.saoBeiProperties.getAccountTransPath()), (String)jsonString, (int)2000, (String)"application/json", (String)"utf-8");
        log.info("\u626b\u5457CBK\u4f59\u989d\u5206\u8d26\u8fd4\u56de\u62a5\u6587: {}", (Object)responseStr);
        return (SaobeiTransRespVO)JSON.parseObject((String)responseStr, SaobeiTransRespVO.class);
    }

    @Override
    public SaobeiQueryOrderResponse queryOrder(SaobeiQueryOrderRequest request) throws Exception {
        request.setApi_ver(this.saoBeiProperties.getApiVer());
        request.setInst_no(this.saoBeiProperties.getInstNo());
        request.setTrace_no(UUID.randomUUID().toString().replace("-", ""));
        JSONObject obj = ApiUtil.convertRequest((Object)request, (String)this.saoBeiProperties.getInstkey(), (String)"key");
        String jsonString = JSON.toJSONString((Object)obj);
        log.info("\u5206\u8d26\u8be6\u60c5\u4fe1\u606f\u67e5\u8be2\u62a5\u6587:{}", (Object)jsonString);
        String responseStr = HttpClientUtil.post((String)(this.saoBeiProperties.getMchServerUrl() + this.saoBeiProperties.getQueryOrderPath()), (String)jsonString, (int)2000, (String)"application/json", (String)"utf-8");
        log.info("\u5206\u8d26\u8be6\u60c5\u4fe1\u606f\u67e5\u8be2\u8fd4\u56de\u62a5\u6587: {}", (Object)responseStr);
        return (SaobeiQueryOrderResponse)JSON.parseObject((String)responseStr, SaobeiQueryOrderResponse.class);
    }

    @Override
    public boolean existFailTransByRootDocNo(String rootDocNo) {
        boolean failFlag = true;
        failFlag = this.creditAccountFlowRepo.existsByRootDocNoAndSyncStatusIn(rootDocNo, FinConstant.SAO_BEI_TRANS_UNFINISHED);
        if (failFlag) {
            return failFlag;
        }
        failFlag = this.accountFlowRepo.existsByRootDocNoAndSyncStatusIn(rootDocNo, FinConstant.SAO_BEI_TRANS_UNFINISHED);
        return failFlag;
    }

    public SaobeiAccountServiceImpl(SaoBeiProperties saoBeiProperties, AccountFlowRepo accountFlowRepo, CreditAccountFlowRepo creditAccountFlowRepo) {
        this.saoBeiProperties = saoBeiProperties;
        this.accountFlowRepo = accountFlowRepo;
        this.creditAccountFlowRepo = creditAccountFlowRepo;
    }
}

