/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFlexibleDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFlexibleValueDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleParam;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinFlexibleDO;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FinFlexibleRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final FinFlexibleRepo finFlexibleRepo;
    private final FinFlexibleValueRepo finFlexibleValueRepo;
    private final QFinFlexibleDO qFinFlexibleDO = QFinFlexibleDO.finFlexibleDO;

    public PagingVO<FinFlexibleDTO> page(FinFlexibleParam finFlexibleParam) {
        Predicate where = this.where(finFlexibleParam);
        JPAQuery query = (JPAQuery)this.select(FinFlexibleDTO.class).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{where}));
        finFlexibleParam.setPaging(query);
        finFlexibleParam.fillOrders(query, this.qFinFlexibleDO);
        List finFlexibleDTOList = query.fetch();
        List<Long> ids = finFlexibleDTOList.stream().map(BaseModelDTO::getId).collect(Collectors.toList());
        List<FinFlexibleValueDTO> finFlexibleValueDOList = FinFlexibleValueConvert.INSTANCE.DOToDTO(this.finFlexibleValueRepo.findAllByMasIdIn(ids));
        if (finFlexibleParam.getDescendantsFlag() != null) {
            finFlexibleValueDOList = finFlexibleValueDOList.stream().filter(item -> finFlexibleParam.getDescendantsFlag().equals(item.getDescendantsFlag())).collect(Collectors.toList());
        }
        for (FinFlexibleDTO finFlexibleDTO : finFlexibleDTOList) {
            List<FinFlexibleValueDTO> flexibleValueDTOS = finFlexibleValueDOList.stream().filter(finFlexibleValueDO -> finFlexibleDTO.getId().equals(finFlexibleValueDO.getMasId())).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(flexibleValueDTOS)) continue;
            flexibleValueDTOS = flexibleValueDTOS.stream().sorted(new Comparator<FinFlexibleValueDTO>(){

                @Override
                public int compare(FinFlexibleValueDTO o1, FinFlexibleValueDTO o2) {
                    return o1.getFlexibleValueCode().compareTo(o2.getFlexibleValueCode());
                }
            }).collect(Collectors.toList());
            finFlexibleDTO.setDetailList(flexibleValueDTOS);
        }
        return PagingVO.builder().total(query.fetchCount()).records(finFlexibleDTOList).build();
    }

    private Predicate where(FinFlexibleParam finFlexibleParam) {
        return BaseRepoProc.PredicateBuilder.builder().andEq(finFlexibleParam.getId() != null, this.qFinFlexibleDO.id, (Object)finFlexibleParam.getId()).andLike(StringUtils.isNotEmpty((CharSequence)finFlexibleParam.getFlexibleCode()), (StringExpression)this.qFinFlexibleDO.flexibleCode, StringUtil.buildLikeString(finFlexibleParam.getFlexibleCode())).andLike(StringUtils.isNotEmpty((CharSequence)finFlexibleParam.getFlexibleName()), (StringExpression)this.qFinFlexibleDO.flexibleName, StringUtil.buildLikeString(finFlexibleParam.getFlexibleName())).andEq(StringUtils.isNotEmpty((CharSequence)finFlexibleParam.getFlexibleType()), (SimpleExpression)this.qFinFlexibleDO.flexibleType, (Object)finFlexibleParam.getFlexibleType()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qFinFlexibleDO.id, this.qFinFlexibleDO.flexibleCode, this.qFinFlexibleDO.flexibleName, this.qFinFlexibleDO.flexibleType, this.qFinFlexibleDO.parentFlexibleCode, this.qFinFlexibleDO.parentFlexibleName, this.qFinFlexibleDO.status, this.qFinFlexibleDO.createTime, this.qFinFlexibleDO.creator, this.qFinFlexibleDO.modifyTime, this.qFinFlexibleDO.updater})).from((EntityPath)this.qFinFlexibleDO);
    }

    public FinFlexibleDO findByFlexibleCode(String flexibleCode) {
        List<FinFlexibleDO> finFlexibleDOList = this.finFlexibleRepo.findAllByFlexibleCode(flexibleCode);
        if (CollectionUtils.isNotEmpty(finFlexibleDOList)) {
            Assert.equals((Object)finFlexibleDOList.size(), (Object)1, (String)"\u67e5\u8be2\u5230\u591a\u6761\u503c\u96c6", (Object[])new Object[0]);
            return finFlexibleDOList.get(0);
        }
        return null;
    }

    public List<FinFlexibleDO> findAllByFlexibleCodeIn(List<String> flexibleCodes) {
        if (CollectionUtils.isEmpty(flexibleCodes)) {
            return Collections.emptyList();
        }
        List<FinFlexibleDO> finFlexibleDOList = this.finFlexibleRepo.findAllByFlexibleCodeIn(flexibleCodes);
        Assert.notEmpty(finFlexibleDOList, (String)"\u67e5\u4e0d\u5230\u503c\u96c6", (Object[])new Object[0]);
        return finFlexibleDOList;
    }

    public List<FinFlexibleDO> findAllByFlexibleCodeInAndStatus(List<String> flexibleCodes, String status) {
        if (CollectionUtils.isEmpty(flexibleCodes)) {
            return Collections.emptyList();
        }
        List<FinFlexibleDO> finFlexibleDOList = this.finFlexibleRepo.findAllByFlexibleCodeInAndStatus(flexibleCodes, status);
        Assert.notEmpty(finFlexibleDOList, (String)"\u67e5\u4e0d\u5230\u503c\u96c6", (Object[])new Object[0]);
        return finFlexibleDOList;
    }

    public FinFlexibleRepoProc(JPAQueryFactory jpaQueryFactory, FinFlexibleRepo finFlexibleRepo, FinFlexibleValueRepo finFlexibleValueRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.finFlexibleRepo = finFlexibleRepo;
        this.finFlexibleValueRepo = finFlexibleValueRepo;
    }
}

