package com.elitesland.fin.application.facade.param.invoice;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @Author: ryan.xu
 * @since 2023/4/19
 */
@Data
@Accessors(chain = true)
@Builder
@ApiModel("待开发票查询入参")
public class PaymentRecordsParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = 8226972337330290479L;

    @ApiModelProperty("收费项目")
    private String chargeType;

    @ApiModelProperty("付款日期开始")
    private LocalDate paymentDateStart;

    @ApiModelProperty(value = "付款日期结束")
    private LocalDate paymentDateEnd;

    @ApiModelProperty("付款状态")
    private String paymentStatus;

    @ApiModelProperty("付款单ID")
    private Long masId;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("客户编码/名称")
    private String custCodeName;

    @ApiModelProperty("待开发票单号")
    private String docNo;

    @ApiModelProperty("待开发票状态")
    private String invoiceAwaitStatus;

    @ApiModelProperty("公司名称")
    private String ouName;
}
