package com.elitesland.fin.infr.repo.artype;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.entity.artype.QArTypeDtlDO;
import com.elitesland.fin.domain.param.artype.ArTypeDtlPageParam;
import com.elitesland.fin.infr.dto.artype.ArTypeDtlDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/02
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class ArTypeDtlRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QArTypeDtlDO qArTypeDtlDO = QArTypeDtlDO.arTypeDtlDO;

    public PagingVO<ArTypeDtlDTO> page(ArTypeDtlPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<ArTypeDtlDTO> query = select(ArTypeDtlDTO.class)
                .where(ExpressionUtils.allOf(where));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qArTypeDtlDO);

        return PagingVO.<ArTypeDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<ArTypeDtlDTO> selectListByParam(ArTypeDtlPageParam param) {
        List<Predicate> where = where(param);
        JPAQuery<ArTypeDtlDTO> query = select(ArTypeDtlDTO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qArTypeDtlDO.id,
                qArTypeDtlDO.masId,
                qArTypeDtlDO.sourceLine,
                qArTypeDtlDO.sourceDoc,
                qArTypeDtlDO.sourceDocType,
                qArTypeDtlDO.sourceDocStatus,
                qArTypeDtlDO.remark,
                qArTypeDtlDO.createTime,
                qArTypeDtlDO.createUserId,
                qArTypeDtlDO.creator,
                qArTypeDtlDO.modifyTime,
                qArTypeDtlDO.modifyUserId,
                qArTypeDtlDO.updater,
                qArTypeDtlDO.deleteFlag
        )).from(qArTypeDtlDO);
    }


    private List<Predicate> where(ArTypeDtlPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();
        if (Objects.nonNull(pageParam.getId())) {
            predicates.add(qArTypeDtlDO.id.eq(pageParam.getId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getIdList())) {
            predicates.add(qArTypeDtlDO.id.in(pageParam.getIdList()));
        }
        if (Objects.nonNull(pageParam.getMasId())) {
            predicates.add(qArTypeDtlDO.masId.eq(pageParam.getMasId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getMasIdList())) {
            predicates.add(qArTypeDtlDO.masId.in(pageParam.getMasIdList()));
        }

        if (CharSequenceUtil.isNotBlank(pageParam.getSourceDoc())) {
            predicates.add(qArTypeDtlDO.sourceDoc.eq(pageParam.getSourceDoc()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getSourceDocList())) {
            predicates.add(qArTypeDtlDO.sourceDoc.in(pageParam.getSourceDocList()));
        }
        if (CharSequenceUtil.isNotBlank(pageParam.getSourceDocType())) {
            predicates.add(qArTypeDtlDO.sourceDocType.eq(pageParam.getSourceDocType()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getSourceDocTypeList())) {
            predicates.add(qArTypeDtlDO.sourceDocType.in(pageParam.getSourceDocTypeList()));
        }
        if (CharSequenceUtil.isNotBlank(pageParam.getSourceDocStatus())) {
            predicates.add(qArTypeDtlDO.sourceDocStatus.eq(pageParam.getSourceDocStatus()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getSourceDocStatusList())) {
            predicates.add(qArTypeDtlDO.sourceDocStatus.in(pageParam.getSourceDocStatusList()));
        }

        return predicates;
    }

}
