package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.*;
import com.elitesland.fin.application.facade.param.accountingengine.FinFastCodeLineParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinFastCodeParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinJournalLogParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinJournalParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinJournalLogVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinJournalVO;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeDO;
import com.elitesland.fin.repo.accountingengine.FinJournalLogRepo;
import com.elitesland.fin.repo.accountingengine.FinJournalLogRepoProc;
import com.elitesland.fin.repo.accountingengine.FinJournalRepo;
import com.elitesland.fin.repo.accountingengine.FinJournalRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class FinJournalLogServiceImpl implements FinJournalLogService {



    private final FinJournalLogRepoProc finJournalLogRepoProc;

    private final FinJournalLogRepo finJournalLogRepo;

    @SysCodeProc
    @Override
    public PagingVO<FinJournalLogVO> page(FinJournalLogParam finJournalLogParam) {
        return FinJournalLogConvert.INSTANCE.DTOToVO(finJournalLogRepoProc.page(finJournalLogParam));
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void save(FinJournalLogParam finJournalLogParam) {
        checkSaveParam(finJournalLogParam);

        finJournalLogRepo.save(FinJournalLogConvert.INSTANCE.paramToDO(finJournalLogParam));
    }

    private void checkSaveParam(FinJournalLogParam finJournalLogParam){
        Assert.notEmpty(finJournalLogParam.getDocNum(), "单据编码必填");
        Assert.notEmpty(finJournalLogParam.getLog(), "日志必填");
    }




}
