/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.vo;

import com.elitesland.fin.infinity.utils.BeanConvertUtil;
import com.elitesland.fin.infinity.vo.ResponseCommVO;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class ResponseVO
implements Serializable {
    private static final long serialVersionUID = -7204196611638488980L;
    public static final String success_code = "200";
    public static final String fail_code = "500";

    public abstract void setCode(String var1);

    public abstract String getCode();

    public abstract void setMessage(String var1);

    public abstract String getMessage();

    public abstract void setData(List<Map<String, Object>> var1);

    public abstract List<Map<String, Object>> getData();

    public abstract void setBizCode(String var1);

    public abstract String getBizCode();

    public static <T extends ResponseVO> T of(String code, String msg) {
        ResponseCommVO resp = new ResponseCommVO();
        resp.setCode(code);
        resp.setMessage(msg);
        return (T)resp;
    }

    public static <T extends ResponseVO> T ok() {
        return ResponseVO.of("S", "\u8c03\u7528\u6210\u529f");
    }

    public static <T extends ResponseVO> T error(String message) {
        return ResponseVO.of("E", message);
    }

    public static <T extends ResponseVO> T error() {
        return ResponseVO.of("E", "\u5185\u90e8\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
    }

    public static <T extends ResponseVO> T empty() {
        return ResponseVO.of("E", "\u65e0\u6570\u636e");
    }

    public static <T extends ResponseVO> T result(String response, Class<T> clazz) {
        return (T)(StringUtils.isBlank((CharSequence)response) ? ResponseVO.empty() : (ResponseVO)BeanConvertUtil.toEntity(response, clazz));
    }

    public static boolean success(ResponseVO res) {
        return ResponseVO.success(res, "S");
    }

    public static boolean success(ResponseVO res, String successCode) {
        return res != null && StringUtils.isNotBlank((CharSequence)res.getCode()) && successCode.equals(res.getCode());
    }

    public static boolean failed(ResponseVO res) {
        return !ResponseVO.success(res, "S");
    }

    public static boolean failed(ResponseVO res, String successCode) {
        return !ResponseVO.success(res, successCode);
    }
}

