package com.elitesland.fin.application.web.nc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.dto.saleinv.SaleInvRpcDTO;
import com.elitesland.fin.param.arorder.ArOrderRpcParam;
import com.elitesland.fin.param.recorder.RecOrderRpcParam;
import com.elitesland.fin.provider.arorder.ArOrderRpcServiceImpl;
import com.elitesland.fin.provider.recorder.RecOrderRpcServiceImpl;
import com.elitesland.fin.provider.saleinv.SaleInvRpcServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/nc/")
@Api(value = "nc同步接口测试", tags = {"nc同步接口测试"})
@AllArgsConstructor
public class NCController {


    private final RecOrderRpcServiceImpl recOrderRpcService;
    private final ArOrderRpcServiceImpl arOrderRpcService;
    private final SaleInvRpcServiceImpl saleInvRpcService;


    @PostMapping("/rec/order/save")
    @ApiOperation("收款单保存")
    public ApiResult<Long> save(@RequestBody RecOrderRpcParam recOrderRpcParam) {
        Long save = recOrderRpcService.save(recOrderRpcParam);
        return ApiResult.ok(save);
    }

    @PostMapping("/querySaleInvById")
    @ApiOperation("销售发票查询")
    public ApiResult<SaleInvRpcDTO> querySaleInvById(@RequestBody Long id) {
        return saleInvRpcService.querySaleInvById(id);
    }

    @PostMapping("/ar/order/save")
    @ApiOperation("应收单保存")
    public ApiResult<Long> save(@RequestBody ArOrderRpcParam arOrderRpcParam) {
        Long save = arOrderRpcService.save(arOrderRpcParam);
        return ApiResult.ok(save);
    }

}
