package com.elitesland.fin.repo.payment;


import com.elitesland.fin.entity.account.AccountRuleConfigDO;
import com.elitesland.fin.entity.payment.PaymentRuleConfigDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Repository

public interface PaymentRuleConfigRepo extends JpaRepository<PaymentRuleConfigDO, Long>, QuerydslPredicateExecutor<AccountRuleConfigDO> {

    /**
     * 根据场景编码查询
     *
     * @param ruleCode
     * @return
     */
    List<PaymentRuleConfigDO> findAllByRuleCode(String ruleCode);

    List<PaymentRuleConfigDO> findAllByOptDoc(String optDoc);
}
