package com.elitesland.fin.application.facade.excel.account;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.fin.application.facade.excel.convert.BigDecimalConvert;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Data
public class AccountImportEntity implements Serializable {
    private static final long serialVersionUID = 6516605491117978659L;

    @ExcelProperty(index = 0)
    private String secOuCode;

    @ExcelProperty(index = 1)
    private String secFranchiseeCode;

    @ExcelProperty(index = 2)
    private String accountHolderType;

    @ExcelProperty(index = 3)
    private String accountHolderName;

    @ExcelProperty(index = 4)
    private String accountCode;

    @ExcelProperty(index = 5)
    private String accountName;

    @ExcelProperty(index = 6)
    private String defaultAccount;

    @ExcelProperty(index = 7)
    private String accountType;

    @ExcelProperty(index = 8, converter = BigDecimalConvert.class)
    private String accountAmount;

    @ExcelProperty(index = 9, converter = BigDecimalConvert.class)
    private String accountOccupancyAmount;

    @ExcelProperty(index = 10, converter = BigDecimalConvert.class)
    private String accountAvailableAmount;

    @ExcelProperty(index = 11)
    private String remark;
}
