package com.elitesland.fin.application.facade.param.saobei.vo;

import com.saobei.open.sdk.SaobeiAllocateApiResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class SaobeiAccountDetailVO extends SaobeiAllocateApiResponse implements Serializable {

    private static final long serialVersionUID = -7108421553937126223L;

    @ApiModelProperty("扫呗CBK账号")
    private String account_no;

    @ApiModelProperty("结算人手机号")
    private String account_phone;

    @ApiModelProperty("结算人身份证号")
    private String account_idnum;

    @ApiModelProperty("开户时间")
    private String open_time;

    @ApiModelProperty("账户状态：1正常 4未激活 9已关闭")
    private String account_status;

    @ApiModelProperty("结算卡开户姓名")
    private String account_name;

    @ApiModelProperty("CBK账户名")
    private String account_custom_name;

    @ApiModelProperty("结算银行卡号")
    private String account_cardno;

    @ApiModelProperty("发卡行名称")
    private String bank_name;

    @ApiModelProperty("CBK账户当前分账通道：5.富友 6中信 7平安")
    private String account_channel;

    @ApiModelProperty("通道子帐号")
    private String channel_account_no;

    @ApiModelProperty("分账通道申请状态 0未申请 1入驻开通成功 2待鉴权 3入驻申请中 4入驻申请驳回 5更换银行卡失败 6已风控 7其他错误 9已关闭")
    private String register_status;

    @ApiModelProperty("结算卡类型：1对公 2对私")
    private String account_type;

    @ApiModelProperty("发卡行名称")
    private String bank_code;

    @ApiModelProperty("通道子帐号")
    private String account_core_no;

    @ApiModelProperty("账户类型：1企业，2个体工商户，3个人(小微商户)")
    private String business_license_type;

    @ApiModelProperty("营业执照名称")
    private String license_name;

    @ApiModelProperty("营业执照号")
    private String license_no;

    @ApiModelProperty("法人名称")
    private String legal_name;

    @ApiModelProperty("法人身份证号")
    private String legal_idnum;
}
