package com.elitesland.fin.application.facade.vo.saobei;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author chaofeng.xia
 * @since 2025/8/18
 */
@ApiModel(value = "扫呗分账信息", description = "扫呗分账信息")
@Data
public class SaoBeiTransVO implements Serializable {

    private static final long serialVersionUID = -2232890921548913755L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("账户类型")
    private String accountType;

    @ApiModelProperty("来源单据状态")
    private String sourceDocStatus;

    @ApiModelProperty("关联流水号")
    private String relateFlowNo;

    @ApiModelProperty("同步状态")
    private String syncStatus;

    @ApiModelProperty("同步异常日志")
    private String syncLog;

    @ApiModelProperty("出账方账号")
    private String fromAccountNo;

    @ApiModelProperty("入账方账号")
    private String toAccountNo;

    @ApiModelProperty("出账公司")
    private String fromOuCode;
    @ApiModelProperty("出账公司名称")
    private String fromOuName;

    @ApiModelProperty("入账公司")
    private String toOuCode;
    @ApiModelProperty("入账公司名称")
    private String toOuName;

    @ApiModelProperty("来源根单据类型")
    private String rootDoc;

    @ApiModelProperty("来源根单号")
    private String rootDocNo;

    @ApiModelProperty("业务类型")
    private String businessType;
    private String businessTypeName;

    @ApiModelProperty("来源单号")
    private String sourceNo;
}
