package com.elitesland.fin.application.service.excel.entity;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.DateTimeToDateConverter;
import com.elitesland.fin.application.facade.excel.convert.DefaultDateTimeConverter;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class AdjustExportEntity implements Serializable {
    @ApiModelProperty("单号")
    private String docNo;
    
    @ApiModelProperty("单据状态")
    private String stateName;
    
    @ApiModelProperty("单据类型")
    private String typeName;
    
    @ApiModelProperty("记账时间")
    @JsonSerialize(using = DateTimeToDateConverter.class)
    private LocalDateTime recAccTime;
    
    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户编码")
    private String accCode;
    
    @ApiModelProperty("账户类型")
    private String accTypeName;

    @ApiModelProperty("区域编码")
    private String regionCode;

    @ApiModelProperty("区域名称")
    private String regionName;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("总金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalAmt;
    
    @ApiModelProperty("审核人")
    private String auditUser;
    
    @ApiModelProperty("审核人id")
    private Long auditUserId;
    
    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;
    
    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;
    
    @ApiModelProperty("公司编码")
    private String ouCode;
    
    @ApiModelProperty("公司名称")
    private String ouName;
    
    @ApiModelProperty("公司id")
    private Long ouId;
    
    @ApiModelProperty("调整原因")
    private String adjReasonName;
    
    @ApiModelProperty("调整类型")
    private String adjTypeName;
    
    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;
    @ApiModelProperty("流程实例状态名称")
    private String procInstStatusName;
    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }
    
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    
    @ApiModelProperty("开户主体名称")
    private String accountHolderName;
    
    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;
    
    @ApiModelProperty(value = "备注")
    private String remark;
    
    @ApiModelProperty("创建时间")
    @ExcelConvert(converter = DateTimeToDateConverter.class, name = "createTime")
    private LocalDate createDate;
    
    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;
    
    @ApiModelProperty(value = "修改人")
    private String updater;
    
    private LocalDateTime modifyTime;
    
    @ApiModelProperty("创建人")
    private String creator;
}
