package com.elitesland.fin.application.service.excel.exp;


import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountConvert;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.excel.entity.CreditAccountExportEntity;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 品牌导出
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/2/2210:10
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class CreditAccountExportServiceImpl implements DataExport<CreditAccountExportEntity, CreditAccountPageParam> {

    private final CreditAccountService creditAccountService;

    @Override
    public String getTmplCode() {
        return "fin_credit_account_export";
    }

    @Override
    @BusinessObjectOperation(permissionRef = FinBusinessObjectConstant.FIN_CREDIT_ACCOUNT_LIST, businessObjectType = FinBusinessObjectConstant.FIN_CREDIT_ACCOUNT,
            operationType = OperationTypeEnum.EXPORT, operationDescription = "信用账户流水导出",operationCode = FinBusinessObjectConstant.FIN_CREDIT_ACCOUNT_EXPORT,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public PagingVO<CreditAccountExportEntity> executeExport(CreditAccountPageParam queryParam) {
        PagingVO<CreditAccountPageVO> pagingVO= creditAccountService.pageSearch(queryParam);
        return new PagingVO<>(
            pagingVO.getTotal(),
            ExcelConvertUtils.convertLoosely(pagingVO.getRecords(), CreditAccountExportEntity.class)
        );
    }
}
