package com.elitesland.fin.application.web.flowrepair;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.flowrepair.AccountFlowRepairPageParam;
import com.elitesland.fin.application.facade.param.flowrepair.AccountFlowRepairParam;
import com.elitesland.fin.application.facade.param.flowrepair.AccountFlowRepairRedoParam;
import com.elitesland.fin.application.facade.vo.flowrepair.AccountFlowRepairVO;
import com.elitesland.fin.application.service.flowrepair.AccountFlowRepairService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/25
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/accountFlow/repair")
@RequiredArgsConstructor
@Api(value = "账户流水修复重算", tags = {"账户流水修复重算"})
public class AccountFlowRepairController {

    private final AccountFlowRepairService accountFlowRepairService;

    @PostMapping("/page")
    @ApiOperation("账户流水修复重算分页查询")
    public ApiResult<PagingVO<AccountFlowRepairVO>> page(@RequestBody AccountFlowRepairPageParam pageParam) {
        var ret = accountFlowRepairService.page(pageParam);
        return ApiResult.ok(ret);
    }

    @PostMapping("/save")
    @ApiOperation("账户流水修复重算保存")
    public ApiResult<Void> save(@RequestBody @Validated AccountFlowRepairParam param) {
        accountFlowRepairService.save(param);
        return ApiResult.ok();
    }

    @DeleteMapping("/deleteBatch")
    @ApiOperation("根据账户流水修复重算ID批量删除")
    public ApiResult<List<Long>> deleteBatch(@RequestBody List<Long> ids) {
        accountFlowRepairService.deleteBatch(ids);
        return ApiResult.ok(ids);
    }

    @PostMapping(value = "/repair/redo")
    @ApiOperation(value = "账户流水修复重算")
    public ApiResult<Void> repairRedo(@RequestBody AccountFlowRepairRedoParam repairRedoParam) {
        accountFlowRepairService.repairRedo(repairRedoParam);
        return ApiResult.ok();
    }

    @PostMapping("/removeFlowNoCacheBatch")
    @ApiOperation("根据流水号批量清空校验缓存")
    public ApiResult<Void> removeFlowNoCacheBatch(@RequestBody List<String> flowNoList) {
        accountFlowRepairService.removeFlowNoCacheBatch(flowNoList);
        return ApiResult.ok();
    }

    @PostMapping(value = "/rollbackBySourceNo")
    @ApiOperation(value = "根据来源单号回滚流水")
    public ApiResult<Void> rollbackBySourceNo(@RequestBody String sourceNo) {
        accountFlowRepairService.rollbackBySourceNo(sourceNo);
        return ApiResult.ok();
    }

}
