package com.elitesland.fin.repo.writeoff;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplySettleDO;
import com.elitesland.fin.domain.entity.writeoff.QFinArRecVerApplySettleDO;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
public class FinArRecVerApplySettleRepoProc extends BaseRepoProc<FinArRecVerApplySettleDO> {

    private static final QFinArRecVerApplySettleDO QDO = QFinArRecVerApplySettleDO.finArRecVerApplySettleDO;

    protected FinArRecVerApplySettleRepoProc() {
        super(QDO);
    }

    public List<FinArRecVerApplySettleDO> listByMasIds(Collection<Long> masIds) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.masId.in(masIds))
                .fetch();
    }

    @Transactional(rollbackFor = Exception.class)
    public Long updateBatchNo(Collection<Long> masIds, String bachNo) {
        return super.updateValueByValue(QDO.batchNo, bachNo, QDO.masId, masIds);
    }

	@Transactional(rollbackFor = Exception.class)
	public Long updateVerFlag(Collection<Long> masIds, String verFlag) {
		return super.updateValueByValue(QDO.verFlag, verFlag, QDO.masId, masIds);
	}

	/**
	 * 更新核销批次号-应收
	 * @param arDid
	 * @param batchNo
	 * @return
	 */
	@Transactional(rollbackFor = Exception.class)
	public Long updateBatchNoByArDid(String arDid, String batchNo) {
		return super.updateValueByValue(QDO.batchNo, batchNo, QDO.outArDId, arDid);
	}

	/**
	 * 更新核销批次号-应收
	 * @param rcDid
	 * @param batchNo
	 * @return
	 */
	@Transactional(rollbackFor = Exception.class)
	public Long updateBatchNoByRcDid(String rcDid, String batchNo) {
		return super.updateValueByValue(QDO.batchNo, batchNo, QDO.outRecDId, rcDid);
	}
}
