package com.elitesland.fin.application.web.invoiceredraft;

import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.invoiceredraft.InvoiceRedraftQueryParam;
import com.elitesland.fin.application.facade.param.invoiceredraft.InvoiceRedraftSaveParam;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.application.service.invoiceredraft.InvoiceRedraftService;
import com.elitesland.fin.domain.entity.base.IdParamVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.seata.spring.annotation.GlobalTransactional;
/**
 * @author sunxw
 * @description
 * @Date 2023/7/14
 */
@RestController
@RequestMapping("/invoice/redraft")
@Api(value = "重新开票", tags = {"重新开票"})
@AllArgsConstructor
public class InvoiceRedraftController {

    private final InvoiceRedraftService invoiceRedraftService;

    @PostMapping("/page")
    @ApiOperation("重新开票-分页")
    public ApiResult<PagingVO<InvoiceRedraftPageVO>> page(@RequestBody InvoiceRedraftQueryParam params){
        PagingVO<InvoiceRedraftPageVO> page = invoiceRedraftService.page(params);
        return ApiResult.ok(page);
    }

    @PostMapping("/detail/{masId}")
    @ApiOperation("重新开票-详情")
    public ApiResult<InvoiceRedraftPageVO> detail(@PathVariable("masId") Long masId){
        val ret = invoiceRedraftService.detail(masId);
        return ApiResult.ok(ret);
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation("重新开票-保存/更新")
    public ApiResult<Long> save(@RequestBody InvoiceRedraftSaveParam param) {
        return ApiResult.ok(invoiceRedraftService.saveOrUpdate(param));
    }

    @GetMapping("/del/{masId}")
    @ApiOperation("重新开票-删除")
    public ApiResult<Void> del(@PathVariable("masId") Long masId) {
        invoiceRedraftService.delById(masId);
        return ApiResult.ok();
    }

    @ApiOperation("【工作流相关】提交流程")
    @PostMapping("/submit")
    @GlobalTransactional
    public ApiResult<?> submit(@RequestBody @Validated IdParamVO paramVO) {
        return ApiResult.ok(invoiceRedraftService.submit(paramVO.getId()));
    }

}
