package com.elitesland.fin.domain.service.arorder;

import com.elitesland.fin.application.facade.param.arorder.ArOrderRecordSaveParam;
import com.elitesland.fin.domain.param.arorder.ArOrderRecordParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderRecordDTO;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/02/28
 * @Version 1.0
 * @Content:
 */
public interface ArOrderRecordDomainService {

    Long save(ArOrderRecordSaveParam saveParam);

    ArOrderRecordDTO selectById(Long id);

    List<ArOrderRecordDTO> selectByParam(ArOrderRecordParam param);

    List<ArOrderRecordDTO> selectDetailsByParam(ArOrderRecordParam param);

    /**
     * 更新是否生成应收单标记
     * @param id 记录表ID
     * @param arFlag 是否生成应收单标记
     * @return
     */
    void updateArFlagById(Long id, String arFlag);

    /**
     * 更新是否生成应收单标记和失败原因
     * @param id 记录表ID
     * @param arFlag 是否生成应收单标记
     * @param failMsg 失败原因
     * @return
     */
    void updateArFlagAndFailMsgById(Long id, String arFlag, String failMsg);

    /**
     * 根据来源单号批量查询记录表ID
     * @param sourceNos 来源单号
     * @return
     */
    List<Long> selectIdBySourceNo(List<String> sourceNos);

    /**
     * 根据记录表ID逻辑删除
     * @param ids 记录表ID
     * @return
     */
    void softDeleteByIds(List<Long> ids);

    /**
     * 根据记录表ID批量物理删除
     * @param ids 记录表ID
     * @return
     */
    void deleteByIds(List<Long> ids);

    /**
     * 根据来源单号批量逻辑删除
     * @param sourceNos 来源单号
     * @return
     */
    void softDeleteBySourceNos(List<String> sourceNos);

    /**
     * 根据来源单号批量物理删除
     * @param sourceNos 来源单号
     * @return
     */
    void deleteBySourceNos(List<String> sourceNos);
}
