package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAccountEngineDetailsConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAccountEngineDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAccountEngineDetailsDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountEngineParam;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinAccountEngineDO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinAccountEngineRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final FinAccountEngineRepo finAccountEngineRepo;
    private final FinAccountEngineDetailsRepo finAccountEngineDetailsRepo;

    private final QFinAccountEngineDO qFinAccountEngineDO = QFinAccountEngineDO.finAccountEngineDO;

    public PagingVO<FinAccountEngineDTO> page(FinAccountEngineParam finAccountEngineParam) {
        Predicate where = where(finAccountEngineParam);
        JPAQuery<FinAccountEngineDTO> query = select(FinAccountEngineDTO.class).where(ExpressionUtils.allOf(where));
        finAccountEngineParam.setPaging(query);
        finAccountEngineParam.fillOrders(query, qFinAccountEngineDO);

        List<FinAccountEngineDTO> finAccountEngineDTOList = query.fetch();

        List<Long> ids = finAccountEngineDTOList.stream().map(FinAccountEngineDTO::getId).collect(Collectors.toList());
        List<FinAccountEngineDetailsDTO> finAccountEngineDetailsDTOList = FinAccountEngineDetailsConvert.INSTANCE.DOToDTO(finAccountEngineDetailsRepo.findAllByMasIdIn(ids));

        for (FinAccountEngineDTO finFastCodeDTO : finAccountEngineDTOList) {
            finFastCodeDTO.setFinAccountEngineDetails(finAccountEngineDetailsDTOList.stream()
                    .filter(finAccountEngineDetailsDTO -> finFastCodeDTO.getId().equals(finAccountEngineDetailsDTO.getMasId()))
                    .collect(Collectors.toList()));
        }

        return PagingVO.<FinAccountEngineDTO>builder()
                .total(finAccountEngineDTOList.size())
                .records(finAccountEngineDTOList)
                .build();
    }

    private Predicate where(FinAccountEngineParam finAccountEngineParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finAccountEngineParam.getId() != null, qFinAccountEngineDO.id, finAccountEngineParam.getId())
                .andLike(StringUtils.isNotEmpty(finAccountEngineParam.getEventTable()), qFinAccountEngineDO.eventTable, StringUtil.buildLikeString(finAccountEngineParam.getEventTable()))
                .andEq(StringUtils.isNotEmpty(finAccountEngineParam.getStatus()), qFinAccountEngineDO.status, finAccountEngineParam.getStatus())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinAccountEngineDO.id,
                qFinAccountEngineDO.eventTable,
                qFinAccountEngineDO.eventTableId,
                qFinAccountEngineDO.columnCompany,
                qFinAccountEngineDO.journalHost,
                qFinAccountEngineDO.journalPort,
                qFinAccountEngineDO.journalUser,
                qFinAccountEngineDO.journalPassword,
                qFinAccountEngineDO.journalDatabase,
                qFinAccountEngineDO.journalTable,
                qFinAccountEngineDO.status,
                qFinAccountEngineDO.columnDocNum,

                qFinAccountEngineDO.createTime,
                qFinAccountEngineDO.creator,
                qFinAccountEngineDO.modifyTime,
                qFinAccountEngineDO.updater
        )).from(qFinAccountEngineDO);
    }


    public FinAccountEngineDO findByEventTable(String eventTable) {

        List<FinAccountEngineDO> finAccountEngineDOList = finAccountEngineRepo.findAllByEventTable(eventTable);

        if (CollectionUtils.isNotEmpty(finAccountEngineDOList)) {
            Assert.equals(finAccountEngineDOList.size(), 1, "查询到多条会计引擎");
            return finAccountEngineDOList.get(0);
        }
        return null;
    }

    public FinAccountEngineDO findById(Long id){
        return finAccountEngineRepo.findById(id).get();
    }


}
