package com.elitesland.fin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/9/25 10:02
 * @Description:
 */
public class CollectionUtil {

    /**
     * 根据指定的属性去重集合
     *
     * @param collection   要去重的集合
     * @param keyExtractor 用于提取去重键的函数
     * @param <T>          集合中元素的类型
     * @param <R>          去重键的类型
     * @return 去重后的列表
     */
    public static <T, R> List<T> distinctByKey(Collection<T> collection, Function<T, R> keyExtractor) {
        return new ArrayList<>(collection.stream()
                .collect(Collectors.toMap(
                        keyExtractor, // 提取去重键
                        t -> t,      // 使用整个对象作为值
                        (existing, replacement) -> existing // 如果键重复，保留第一个
                ))
                .values()); // 转换回 List<T>
    }

    /**
     * 根据指定的属性去重集合，并返回指定类型的集合
     *
     * @param collection   要去重的集合
     * @param keyExtractor 用于提取去重键的函数
     * @param <T>          集合中元素的类型
     * @param <R>          去重键的类型
     * @param <C>          返回集合的类型
     * @return 去重后的集合
     */
    public static <T, R, C extends Collection<T>> C distinctByKey(Collection<T> collection,
                                                                  Function<T, R> keyExtractor,
                                                                  java.util.function.Supplier<C> collectionFactory) {
        return collection.stream()
                .collect(Collectors.toMap(
                        keyExtractor, // 提取去重键
                        t -> t,      // 使用整个对象作为值
                        (existing, replacement) -> existing // 如果键重复，保留第一个
                ))
                .values()
                .stream()
                .collect(Collectors.toCollection(collectionFactory)); // 使用提供的集合工厂
    }
}
