/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.fin.application.convert.invoice.InvoiceConvert;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.dto.mq.DemoMqMessageDTO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceSaveVO;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.invoice.InvoiceSaveService;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.PaymentRecordTypeEnum;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtl;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.infinity.aisino.enums.RedStateEnum;
import com.elitesland.fin.infinity.aisino.service.AisinoPayloadService;
import com.elitesland.fin.infinity.aisino.service.AisinoService;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoBlueInvoiceApplyParam;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoCoverParamPayload;
import com.elitesland.fin.infinity.aisino.vo.param.InvoiceRequestSerialNoParam;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoResultResp;
import com.elitesland.fin.infinity.aisino.vo.resp.BlueInvoiceApplyRespVO;
import com.elitesland.fin.infr.dto.invoice.InvoiceApplyDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepoProc;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.utils.SysUtils;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public abstract class AbstractInvoiceSaveServiceImpl
implements InvoiceSaveService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractInvoiceSaveServiceImpl.class);
    protected static final Map<PaymentRecordTypeEnum, AbstractInvoiceSaveServiceImpl> SERVICE_MAP = new HashMap<PaymentRecordTypeEnum, AbstractInvoiceSaveServiceImpl>();
    @Autowired
    protected SaleInvRepoProc saleInvRepoProc;
    @Autowired
    @Lazy
    protected AisinoService aisinoService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    @Lazy
    private InvoiceAwaitService invoiceAwaitService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private FlexFieldUtilService flexFieldUtilService;
    @Autowired
    private SaleInvRepo saleInvRepo;
    @Autowired
    private SaleInvDtlRepoProc saleInvDtlRepoProc;
    @Autowired
    protected InvoiceAwaitRepoProc invoiceAwaitRepoProc;
    @Autowired
    private SaleInvDomainService saleInvDomainService;
    @Autowired
    private WorkflowRpcService workflowRpcService;
    @Autowired
    private MessageQueueTemplate messageQueueTemplate;
    @Autowired
    private SaleInvDtlRepo saleInvDtlRepo;
    @Autowired
    private SaleInvdDtlRepo saleInvdDtlRepo;
    @Autowired
    private AisinoPayloadService aisinoPayloadService;
    @Autowired
    private SaleInvService saleInvService;

    public void afterPropertiesSet() {
        SERVICE_MAP.put(this.getSourceType(), this);
    }

    protected abstract PaymentRecordTypeEnum getSourceType();

    protected abstract void callBackMethod(List<InvoiceAwaitRespVO> var1, List<InvoiceApplyDTO> var2);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<InvoiceSaveVO> save(InvoiceApplyParam param) {
        PaymentRecordTypeEnum strategyEnum;
        log.info("\u5f00\u59cb\u4fdd\u5b58\u5f00\u7968\u5355,\u5165\u53c2\u4e3a{}", (Object)JSON.toJSONString((Object)param));
        List<InvoiceAwaitRespVO> records = this.invoiceAwaitService.checkAndQueryInvoiceAwait(param);
        String sourceType = this.getSourceType(records);
        try {
            strategyEnum = PaymentRecordTypeEnum.valueOf(sourceType);
        }
        catch (IllegalArgumentException e) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u7c7b\u578b\u672a\u5b9a\u4e49");
        }
        AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService = SERVICE_MAP.get((Object)strategyEnum);
        if (Objects.isNull(abstractInvoiceSaveService)) {
            throw new BusinessException("\u672a\u5b9a\u4e49\u6b64\u6765\u6e90\u5355\u636e\u7c7b\u578b\u7684\u5b9e\u73b0\u7c7b\uff0c\u7c7b\u578b\u4e3a" + strategyEnum);
        }
        List<InvoiceApplySaveParam> saveParamList = this.invoiceAwaitService.getInvoiceApplySaveParams(records, param);
        log.info("\u5f00\u59cb\u8c03\u7528\u5f00\u7968\u5355\u521b\u5efa\u65b9\u6cd5,\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString(saveParamList));
        ArrayList<InvoiceApplyDTO> applyList = new ArrayList<InvoiceApplyDTO>();
        saveParamList.forEach(saveParam -> {
            InvoiceApplyDTO apply = this.saveAndSubmitInvoice((InvoiceApplySaveParam)saveParam);
            if (apply == null || apply.getApplyId() == null) {
                log.error("\u5f00\u7968\u7533\u8bf7\u5355\u521b\u5efa\u7ed3\u679c\u4e3a\u7a7a\uff0c\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)saveParam));
                throw new BusinessException("\u5f00\u7968\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            saveParam.setApplyNo(apply.getApplyNo());
            saveParam.setId(apply.getApplyId());
            applyList.add(apply);
        });
        abstractInvoiceSaveService.callBackMethod(records, applyList);
        ArrayList<InvoiceSaveVO> resultList = new ArrayList<InvoiceSaveVO>();
        for (InvoiceApplyDTO invoiceApplyDTO : applyList) {
            InvoiceSaveVO result = new InvoiceSaveVO();
            result.setApplyId(invoiceApplyDTO.getApplyId());
            result.setApplyNo(invoiceApplyDTO.getApplyNo());
            resultList.add(result);
        }
        log.info("\u5f00\u7968\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f\uff0c\u7ed3\u679c\u4e3a{}", (Object)JSON.toJSONString(resultList));
        return resultList;
    }

    public InvoiceApplyDTO saveAndSubmitInvoice(InvoiceApplySaveParam param) {
        SaleInv saleInv = InvoiceConvert.INSTANCE.toSaleInv(param);
        saleInv.setOrderState(UdcEnum.INVOICE_STATUS_DRAFT.getValueCode());
        param.setInvoiceAwaitStatus(UdcEnum.INVOICE_AWAIT_STATUS_ING.getValueCode());
        saleInv.check();
        saleInv.checkDtl();
        log.info("[YST-FIN] saleInv: {}", (Object)saleInv);
        this.transactionTemplate.setPropagationBehavior(3);
        SaleInvDO execute = (SaleInvDO)this.transactionTemplate.execute(transactionStatus -> {
            try {
                SaleInvDO convertDO = SaleInvConvert.INSTANCE.convert(saleInv);
                log.info("[YST-FIN] convertDO: {}", (Object)convertDO);
                this.flexFieldUtilService.handFlexFieldValueFeference("SALE_INV", (Object)convertDO);
                SaleInvDO save = (SaleInvDO)this.saleInvRepo.save(convertDO);
                this.saleInvDtlRepoProc.delByMasId(List.of(save.getId()));
                List<SaleInvDtl> saleInvDtls = saleInv.getSaleInvDtls();
                List<SaleInvDtlDO> details = SaleInvConvert.INSTANCE.convertListDO(saleInvDtls);
                log.info("[YST-FIN] convert details: {}", details);
                details.forEach(row -> {
                    row.setMasId(save.getId());
                    this.saleInvDtlRepo.save(row);
                });
                return save;
            }
            catch (Exception e) {
                log.error("\u5f85\u5f00\u53d1\u7968\u751f\u6210\u9500\u552e\u53d1\u7968\u51fa\u9519:{}", (Object)e.getMessage(), (Object)e);
                transactionStatus.setRollbackOnly();
                throw new com.elitescloud.boot.exception.BusinessException(ApiCode.FAIL, "\u5f85\u5f00\u53d1\u7968\u751f\u6210\u9500\u552e\u53d1\u7968\u4fdd\u5b58\u65f6\u51fa\u9519");
            }
        });
        Set<Long> awaitId = param.getDetails().stream().map(InvoiceDetailSaveParam::getInvoiceAwaitId).filter(Objects::nonNull).collect(Collectors.toSet());
        InvoiceApplyDTO result = new InvoiceApplyDTO();
        result.setApplyId(execute.getId());
        result.setApplyNo(execute.getApplyNo());
        result.setInvoiceAwaitIds(awaitId);
        return result;
    }

    private BigDecimal add(List<InvoiceDetailSaveParam> details, Function<InvoiceDetailSaveParam, BigDecimal> func) {
        return details.stream().map(func).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public Boolean invoiceApply(InvoiceApplySaveParam saveParam, SaleInvdDtlDO saleInvdDtlDO) {
        Map<String, List<InvoiceDetailSaveParam>> collect = saveParam.getDetails().stream().collect(Collectors.groupingBy(InvoiceDetailSaveParam::getItemCode));
        ArrayList<InvoiceDetailSaveParam> result = new ArrayList<InvoiceDetailSaveParam>();
        String technologyCostsItemCode = SysUtils.getTechnologyCosts();
        String marketingCostsItemCode = SysUtils.getMarketingCosts();
        String operatingCostsItemCode = SysUtils.getOperatingCosts();
        List<String> costsItemCodes = List.of(technologyCostsItemCode, marketingCostsItemCode, operatingCostsItemCode);
        log.info("costsItemCodes22: {}", costsItemCodes);
        collect.forEach((itemCode, details) -> {
            InvoiceDetailSaveParam row = (InvoiceDetailSaveParam)details.get(0);
            InvoiceDetailSaveParam curr = new InvoiceDetailSaveParam();
            curr.setInvNature(row.getInvNature());
            curr.setItemId(row.getItemId());
            curr.setItemCode(row.getItemCode());
            curr.setItemName(row.getItemName());
            curr.setTaxCode(row.getTaxCode());
            curr.setTaxName(row.getTaxName());
            curr.setItemType(row.getItemType());
            curr.setUom(row.getUom());
            curr.setUomName(row.getUomName());
            if (costsItemCodes.contains(row.getItemCode())) {
                curr.setQty(BigDecimal.ONE);
            } else {
                curr.setQty(this.add((List<InvoiceDetailSaveParam>)details, InvoiceDetailSaveParam::getQty));
            }
            BigDecimal priceTotal = this.add((List<InvoiceDetailSaveParam>)details, InvoiceDetailSaveParam::getTotalAmt);
            curr.setPrice(priceTotal.divide(curr.getQty(), 2, RoundingMode.HALF_UP));
            curr.setTotalAmt(this.add((List<InvoiceDetailSaveParam>)details, InvoiceDetailSaveParam::getTotalAmt));
            curr.setTaxRate(row.getTaxRate());
            curr.setTaxAmt(this.add((List<InvoiceDetailSaveParam>)details, InvoiceDetailSaveParam::getTaxAmt));
            curr.setExclTaxAmt(this.add((List<InvoiceDetailSaveParam>)details, InvoiceDetailSaveParam::getExclTaxAmt));
            curr.setFlDeductionAmt(this.add((List<InvoiceDetailSaveParam>)details, InvoiceDetailSaveParam::getFlDeductionAmt));
            curr.setInvDiscountAmt(this.add((List<InvoiceDetailSaveParam>)details, InvoiceDetailSaveParam::getInvDiscountAmt));
            curr.setDiscountAmt(this.add((List<InvoiceDetailSaveParam>)details, InvoiceDetailSaveParam::getDiscountAmt));
            curr.setInvAmt(this.add((List<InvoiceDetailSaveParam>)details, InvoiceDetailSaveParam::getInvAmt));
            Set rootDocNoSet = details.stream().map(InvoiceDetailSaveParam::getRootDocNo).filter(Objects::nonNull).collect(Collectors.toSet());
            Object rootDocNos = "";
            if (CollectionUtil.isNotEmpty(rootDocNoSet) && ((String)(rootDocNos = String.join((CharSequence)",", rootDocNoSet))).length() > 100) {
                rootDocNos = ((String)rootDocNos).substring(0, 100) + "...";
            }
            curr.setRootDocNo((String)rootDocNos);
            curr.setConfirmTime(row.getConfirmTime());
            result.add(curr);
        });
        if (CollectionUtil.isNotEmpty(result)) {
            saveParam.setDetails(result);
        }
        AisinoBlueInvoiceApplyParam applyParam = this.aisinoPayloadService.blueInvoiceApplyInitial(saveParam, saleInvdDtlDO, costsItemCodes);
        String initialParam = JSON.toJSONString((Object)applyParam);
        AisinoCoverParamPayload finialParam = this.aisinoPayloadService.assembleAisinoPayload(initialParam, saveParam.getSaleTaxNo());
        BlueInvoiceApplyRespVO response = null;
        String failCause = null;
        try {
            response = this.aisinoService.blueInvoiceApply(finialParam, initialParam);
        }
        catch (Exception e) {
            log.error("\u84dd\u7968\u7533\u8bf7\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            failCause = e.getMessage();
        }
        if (saleInvdDtlDO == null) {
            saleInvdDtlDO = new SaleInvdDtlDO();
            saleInvdDtlDO.setCreator(saveParam.getInvUser());
        }
        if (Strings.isNotBlank(failCause)) {
            saleInvdDtlDO.setInvFailCause(failCause);
        }
        saleInvdDtlDO.setRedBlueType(UdcEnum.INV_RED_BLUE_TYPE_BLUE.getValueCode());
        saleInvdDtlDO.setOriginalContent(initialParam);
        saleInvdDtlDO.setMasId(saveParam.getId());
        saleInvdDtlDO.setFlowNo(applyParam.getFPQQLSH());
        BigDecimal totalAmt = new BigDecimal(applyParam.getREQUEST().getJSHJ());
        saleInvdDtlDO.setTotalAmt(totalAmt);
        saleInvdDtlDO.setSaleTaxNo(saveParam.getSaleTaxNo());
        return this.saveSaleInvDDtl(saleInvdDtlDO, response, failCause);
    }

    private Boolean saveSaleInvDDtl(SaleInvdDtlDO saleInvdDtlDO, BlueInvoiceApplyRespVO response, String failCause) {
        saleInvdDtlDO.setInvDate(LocalDateTime.now());
        String orderState = null;
        boolean result = false;
        if (response != null && Arrays.asList("0000", "200").contains(response.getCODE())) {
            BlueInvoiceApplyRespVO.Data data = response.getDATA();
            saleInvdDtlDO.setInvState(RedStateEnum.BLUE_APPLY_SUCCESS.getCode());
            saleInvdDtlDO.setInvNo(data.getFPHM());
            saleInvdDtlDO.setInvFailCause(null);
            saleInvdDtlDO.setRedState(UdcEnum.RED_STATE_NO.getValueCode());
            if (Strings.isNotBlank((String)data.getKPRQ())) {
                LocalDateTime invoiceDate = LocalDateTime.parse(data.getKPRQ(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                saleInvdDtlDO.setInvDate(invoiceDate);
            }
            switch (data.getKPZT()) {
                case "1": {
                    saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_SUCCESS.getValueCode());
                    orderState = UdcEnum.INV_STATE_SUCCESS.getValueCode();
                    saleInvdDtlDO.setInvPdfUrl(data.getFPURL());
                    saleInvdDtlDO.setInvFailCause(data.getKPZT_MSG());
                    result = true;
                    break;
                }
                case "2": {
                    saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_FAIL.getValueCode());
                    orderState = UdcEnum.INV_STATE_FAIL.getValueCode();
                    saleInvdDtlDO.setInvFailCause(data.getKPZT_MSG());
                    break;
                }
                case "0": {
                    saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_ING.getValueCode());
                    orderState = UdcEnum.INV_STATE_ING.getValueCode();
                }
            }
        } else {
            saleInvdDtlDO.setInvState(UdcEnum.INV_STATE_FAIL.getValueCode());
            saleInvdDtlDO.setInvFailCause(response != null ? response.getRETURNMESSAGE() : (Strings.isNotBlank((String)failCause) ? failCause : "\u5f00\u7968\u7533\u8bf7\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a"));
            orderState = UdcEnum.INV_STATE_FAIL.getValueCode();
        }
        this.saleInvdDtlRepo.save(saleInvdDtlDO);
        this.saleInvRepo.updateOrderStateById(orderState, saleInvdDtlDO.getMasId());
        return result;
    }

    public Boolean invoiceReApply(SaleInvdDtlDO saleInvdDtlDO) {
        String initialParam = saleInvdDtlDO.getOriginalContent();
        AisinoCoverParamPayload finialParam = this.aisinoPayloadService.assembleAisinoPayload(initialParam, saleInvdDtlDO.getSaleTaxNo());
        BlueInvoiceApplyRespVO response = null;
        String failCause = null;
        try {
            response = this.aisinoService.blueInvoiceApply(finialParam, initialParam);
        }
        catch (Exception e) {
            log.error("\u84dd\u7968\u7533\u8bf7\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            failCause = e.getMessage();
        }
        return this.saveSaleInvDDtl(saleInvdDtlDO, response, failCause);
    }

    public Boolean getInvoiceInfoByFlowNo(SaleInvdDtlDO saleInvdDtlDO) {
        String failCause = null;
        BlueInvoiceApplyRespVO response = null;
        try {
            InvoiceRequestSerialNoParam applyParam = this.aisinoPayloadService.getInvoiceInfoByFlowNo(saleInvdDtlDO);
            String initialParam = JSON.toJSONString((Object)applyParam);
            AisinoCoverParamPayload finialParam = this.aisinoPayloadService.assembleAisinoPayload(initialParam, saleInvdDtlDO.getSaleTaxNo());
            response = this.aisinoService.getInvoiceInfoByFlowNo(finialParam, initialParam);
        }
        catch (Exception e) {
            String msg = "\u83b7\u53d6\u5f00\u7968\u7ed3\u679c\u5931\u8d25:" + e.getMessage();
            log.error(msg, (Throwable)e);
            failCause = msg;
        }
        return this.saveSaleInvDDtl(saleInvdDtlDO, response, failCause);
    }

    public void getBlueResult(SaleInvdDtlDO saleInvDO) {
        if (saleInvDO.getInvNo() != null && saleInvDO.getInvDate() != null) {
            String blueResultParam = this.aisinoPayloadService.getBlueResult(saleInvDO.getInvNo(), saleInvDO.getInvDate());
            AisinoCoverParamPayload payload = this.aisinoPayloadService.assembleAisinoPayload(blueResultParam, saleInvDO.getSaleTaxNo());
            AisinoResultResp aisinoResultResp = this.aisinoService.blueInvoiceResult(payload, blueResultParam);
            if (Objects.equals(aisinoResultResp.getCODE(), "0000")) {
                AisinoResultResp.Data data1 = aisinoResultResp.getDATA();
                saleInvDO.setInvState(RedStateEnum.BLUE_RESULT_SUCCESS.getCode());
                saleInvDO.setRedState(RedStateEnum.RED_PUNCH.getCode());
                saleInvDO.setInvPdfUrl(data1.getDATA());
            } else {
                log.error("[YST-FIN] \u83b7\u53d6\u84dd\u7968\u5f00\u7968\u7ed3\u679c\u5931\u8d25:{}", (Object)aisinoResultResp.getRETURNMESSAGE());
                saleInvDO.setInvState(RedStateEnum.BLUE_RESULT_FAIL.getCode());
                saleInvDO.setInvFailCause(aisinoResultResp.getRETURNMESSAGE());
            }
        }
    }

    public Boolean getBase64Result(SaleInvdDtlDO saleInvDO) {
        AisinoResultResp.Data data1;
        String param;
        AisinoCoverParamPayload payload;
        AisinoResultResp aisinoResultResp;
        if (saleInvDO.getInvNo() != null && saleInvDO.getInvDate() != null && Objects.equals((aisinoResultResp = this.aisinoService.blueInvoiceResultBase64(payload = this.aisinoPayloadService.assembleAisinoPayload(param = this.aisinoPayloadService.getBase64Result(saleInvDO.getInvNo(), saleInvDO.getInvDate()), saleInvDO.getSaleTaxNo()), param)).getCODE(), "200") && (data1 = aisinoResultResp.getDATA()).getDATA() != null) {
            saleInvDO.setInvPdfBase64(data1.getDATA());
            return true;
        }
        return false;
    }

    @NotNull
    private String getSourceType(List<InvoiceAwaitRespVO> records) {
        List<String> sourceType = records.stream().map(InvoiceAwaitRespVO::getOptDocCls).distinct().toList();
        if (CollUtil.isEmpty(sourceType)) {
            throw new BusinessException("\u5f00\u7968\u5931\u8d25\uff1a\u6240\u9009\u5355\u636e\u6765\u6e90\u4e3a\u7a7a");
        }
        if (sourceType.size() > 1) {
            throw new BusinessException("\u5f00\u7968\u5931\u8d25\uff1a\u591a\u79cd\u6765\u6e90\u5355\u636e\u4e0d\u80fd\u4e00\u8d77\u5f00\u7968");
        }
        return sourceType.get(0);
    }

    private void workFlow(SaleInvDO saleInvDO) {
        String applyNo = saleInvDO.getApplyNo();
        if (saleInvDO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(saleInvDO.getProcInstStatus())) {
            String procInstName = "\u5f00\u7968\u7533\u8bf7(" + applyNo + ")\u5ba1\u6279";
            String businessKey = "" + saleInvDO.getId();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(WorkFlowDefKey.FIN_SALE_INV.name(), procInstName, businessKey, new HashMap<String, Object>());
            this.saleInvDomainService.updateWorkInfo(processInfo, saleInvDO.getId());
            log.info("\u5f85\u5f00\u53d1\u7968\u7533\u8bf7\u8d70\u5de5\u4f5c\u6d41,\u7533\u8bf7\u9500\u552e\u53d1\u7968\u5355\u53f7 {}, \u5de5\u4f5c\u6d41\u8fd4\u56de {}", (Object)applyNo, (Object)processInfo);
        }
    }

    private void sendMessage(SaleInvDO saleInvDO) {
        DemoMqMessageDTO messageDTO = new DemoMqMessageDTO();
        messageDTO.setId(saleInvDO.getId());
        messageDTO.setCode(saleInvDO.getApplyNo());
        messageDTO.setInterfaceType("zt_to_nc_salinv");
        messageDTO.setDomainCode("yst-fin");
        try {
            this.messageQueueTemplate.publishMessage("yst-fin", "yst-fin", (Serializable)messageDTO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001mq\u6d88\u606f\uff0c\u540c\u6b65\u9500\u552e\u5f00\u7968\u4fe1\u606f\u5230NC\u5931\u8d25,\u540c\u6b65\u5185\u5bb9{}, \u5931\u8d25\u539f\u56e0\uff1a{}", (Object)messageDTO, (Object)e.getMessage());
            throw new com.elitescloud.boot.exception.BusinessException("\u540c\u6b65\u9500\u552e\u5f00\u7968\u4fe1\u606f\u5230NC\u5931\u8d25");
        }
    }
}

