package com.elitesland.fin.application.facade.param.saobei.vo;

import com.saobei.open.sdk.SaobeiAllocateApiResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class SaobeiBalanceDetailVO extends SaobeiAllocateApiResponse implements Serializable {

    private static final long serialVersionUID = -5852938570979688579L;

    @ApiModelProperty("CBK账号")
    private String account_no;

    @ApiModelProperty("账户总额,查询的账户的账户总额（冻结金额+账户可用金额+待结算金额）单位分")
    private String total_bal;

    @ApiModelProperty("冻结金额,查询的账户已冻结的金额（账户总额-账户可用金额-待结算金额）单位分")
    private String freeze_bal;

    @ApiModelProperty("账户可用金额,也为可提现金额或者可发起冻结的金额（账户总额-冻结金额-待结算金额）单位分")
    private String available_bal;

    /**
     * 特殊说明：平安通道若申请了待结算金额可用于分账，需与available_bal相加，为可分账金额
     */
    @ApiModelProperty("待结算金额（不可提现，不可用于冻结） 单位分。")
    private String prepaid_bal;

    /**
     * 特殊说明：1.中信通道开通一卡多户后，该字段会返回多账户共用账户的余额，账户可用余额+该字段余额即为采购可用资金。
     * 2.若系统方在自有系统为加盟商展示CBK余额，需将该字段金额单独展示为多账户共用金额。
     */
    @ApiModelProperty("一卡多户共用充值入金户的余额（不可提现，不可用于冻结，不可用于退款）")
    private String recharge_dedicated_amt;

    /**
     * 特殊说明：可分账金额根据CBK后台多种条件计算得出，并不一定等于接口中其它几个字段之和，具体金额明细可查阅CBK后台账户详情。
     * 可分账金额不代表可提现金额，也不代表账户实际余额，且不可用于发起冻结。
     */
    @ApiModelProperty("可分账金额(api_ver=102时返回)")
    private String transferable_amt;
}
