package com.elitesland.fin.application.service.workflow.inputinv;

import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;

import java.util.ArrayList;

/**
 * @date 2022/5/11 10:22
 */
public interface InputInvProcessService {

    /**
     * 回调
     *
     * @param id             业务id
     * @param procInstStatus 业务状态
     */
    void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo);

    /**
     * 根据公司和角色编码查找对应处理人
     *
     * @param businessKey  业务主键
     * @param customParams 自定义编码
     *
     * @return 用户id
     */
    ArrayList<String> taskAssignee(String businessKey, String customParams);

}
