package com.elitesland.fin.application.facade.dto.flowrepair;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/26
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "creditAccountFlowRepairHandleDTO",description = "信用账户流水修复重算处理计算DTO")
public class CreditAccountFlowRepairHandleDTO implements Serializable {
    private static final long serialVersionUID = 2340012089545249847L;

    @ApiModelProperty(value = "流水修复表的ID")
    private Long flowRepairId;


    @ApiModelProperty(value = "流水修复表的流水号")
    private String flowRepairFlowNo;

    @ApiModelProperty(value = "流水表的ID")
    private Long flowId;

    @ApiModelProperty(value = "流水表的流水号")
    private String flowNo;

    @ApiModelProperty(value = "实际金额")
    private BigDecimal actualAmount;

    @ApiModelProperty(value = "原流水发生金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "变动金额")
    private BigDecimal variableAmount;

    @ApiModelProperty(value = "账户类型")
    private String accountType;

    @ApiModelProperty(value = "账户编码")
    private String accountCode;

    @ApiModelProperty(value = "账户名称")
    private String accountName;

    @ApiModelProperty("交易类型")
    private String transactionType;


    @ApiModelProperty("账户额度")
    private BigDecimal creditAccountLimit;

    @ApiModelProperty("账户使用额度")
    private BigDecimal creditAccountUsedLimit;

    @ApiModelProperty("占用额度")
    private BigDecimal creditAccountOccupancyLimit;

    @ApiModelProperty("可用额度")
    private BigDecimal creditAccountAvailableLimit;

    @ApiModelProperty(value = "重算原因 [UDC]yst-fin:FLOW_RECALCUL_REASON")
    private String recalculationReason;

    @ApiModelProperty(value = "重算日期")
    private LocalDateTime recalculationDate;

}
