package com.elitesland.fin.application.facade.vo.invoice;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: ryan.xu
 * @since 2023/4/6
 */
@Data
@ApiModel(value = "支付凭证保存参数")
public class PaymentVoucherSaveVO implements Serializable {
    private static final long serialVersionUID = -6534581465947562391L;

    @ApiModelProperty("支付凭证表ID")
    private Long id;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    @NotNull(message = "主表ID不能为空")
    private Long masId;

    @ApiModelProperty("公司ID")
    @NotNull(message = "公司ID不能为空")
    private Long ouId;
    /**
     * 付款账户
     */
    @ApiModelProperty("付款账户")
    @NotBlank(message = "付款账户不能为空")
    private String paymentAccount;
    /**
     * 付款账号
     */
    @ApiModelProperty("付款账号")
    @NotBlank(message = "付款账号不能为空")
    private String paymentAccountNumber;
    /**
     * 付款金额
     */
    @ApiModelProperty("付款金额")
    @NotNull(message = "付款金额不能为空")
    private BigDecimal paymentAmt;
    /**
     * 支付凭证编码
     */
    @ApiModelProperty("支付凭证编码")
    @NotBlank(message = "支付凭证编码不能为空")
    private String voucherFileCode;

    @ApiModelProperty("联行号")
    private String uniBankNo;

    @ApiModelProperty("备注")
    private String remark;
}
