package com.elitesland.fin.infr.repo.artype;


import com.elitesland.fin.domain.entity.artype.ArTypeDtlDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/02
 * @Version 1.0
 * @Content:
 */
@Repository
public interface ArTypeDtlRepo extends JpaRepository<ArTypeDtlDO, Long>, QuerydslPredicateExecutor<ArTypeDtlDO> {

    /**
     * 根据主表id查询应收单类型明细
     * @param masId 主表id
     * @return
     */
    List<ArTypeDtlDO> findAllByMasId(Long masId);

    /**
     * 根据主表id集合查询应收单类型明细
     * @param masIdList 主表id集合
     * @return
     */
    List<ArTypeDtlDO> findAllByMasIdIn(List<Long> masIdList);

    /**
     * 根据主表id集合删除应收单类型明细
     * @param masIdList 主表id集合
     * @return
     */
    void deleteAllByMasIdIn(List<Long> masIdList);

}
