package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeLineDO;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinFastCodeLineRepoProc {


    private final FinFastCodeLineRepo finFastCodeLineRepo;



    public List<FinFastCodeLineDO> findByMasIdIn(List<Long> ids) {

        if(CollectionUtils.isEmpty(ids)){
            return Lists.newArrayList();
        }

        List<FinFastCodeLineDO> finFastCodeLineDOList = finFastCodeLineRepo.findAllByMasIdIn(ids);
        Assert.notEmpty(finFastCodeLineDOList,"查不到快码明细");

        return finFastCodeLineDOList;
    }


}
