package com.elitesland.fin.repo.writeoff;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyVO;
import com.elitesland.fin.domain.entity.writeoff.*;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
public class FinArRecVerApplyRepoProc extends BaseRepoProc<FinArRecVerApplyDO> {

    private static final QFinArRecVerApplyDO QDO = QFinArRecVerApplyDO.finArRecVerApplyDO;
    private static final QFinArRecVerApplyArDO QArDO = QFinArRecVerApplyArDO.finArRecVerApplyArDO;
    private static final QFinArRecVerApplyRecDO QRecDO = QFinArRecVerApplyRecDO.finArRecVerApplyRecDO;
    private static final QFinArRecVerApplyArHeadDO QArHeadDO = QFinArRecVerApplyArHeadDO.finArRecVerApplyArHeadDO;
    private static final QFinArRecVerApplyRecHeadDO QRecHeadDO = QFinArRecVerApplyRecHeadDO.finArRecVerApplyRecHeadDO;

    protected FinArRecVerApplyRepoProc() {
        super(QDO);
    }

    /**
     * 分页查询.
     *
     * @param query 查询参数
     * @return 记录列表
     */
    public PagingVO<FinArRecVerApplyDO> page(FinArRecVerApplyQuery query) {
        // 查询条件
        Predicate predicate = PredicateBuilder.builder()
                .andEq(QDO.state, query.getState())
                .andEq(QDO.verState, query.getVerState())
                .build();

        return super.queryByPage(predicate, query.getPageRequest(), QDO.createTime.desc());
    }

    private final QBean<FinArRecVerApplyVO> applyDOQBean = Projections.bean(
            FinArRecVerApplyVO.class,
            QDO.id,
            QDO.inOutCust,
            QDO.applyDocNo,
            QDO.state,
            QDO.verState,
            QDO.verAmt,
            QDO.applyDate,
            QDO.applyUserId,
            QDO.applyUserCode,
            QDO.applyUserName,
            QDO.approvalDate,
            QDO.approvalUserId,
            QDO.approvalUserCode,
            QDO.approvalUserName,
            QDO.approvalRemark,
            QDO.headFlag,
            QDO.proposedStatus,
            QDO.ouCode,
            QDO.ouName,
            QDO.ouId,
            QDO.schemeId,
            QDO.verMode,
            QDO.createTime,
            QDO.modifyTime,
            QDO.creator,
            QDO.updater,
            QDO.createUserId,
            QDO.modifyUserId);

    /**
     * 分页查询.
     *
     * @param query 查询参数
     * @return 记录列表
     */
    public PagingVO<FinArRecVerApplyVO> joinPage(FinArRecVerApplyQuery query) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(QDO.state, query.getState())
                .andEq(QDO.verState, query.getVerState())
                .andLike(QDO.applyDocNo, query.getApplyDocNo())
                .andEq(QDO.applyUserId, query.getApplyUserId())
                .andLike(QDO.applyUserName, query.getApplyUserName())
                .andEq(QDO.approvalUserId, query.getApprovalUserId())
                .andLike(QDO.approvalUserName, query.getApprovalUserName())
                .andBetween(QDO.applyDate, query.getApplyDateS(), query.getApplyDateE())
                .andBetween(QDO.approvalDate, query.getApprovalDateS(), query.getApprovalDateE())
                .andEq(QArDO.custId, query.getArCustId())
                .andEq(QArDO.custCode, query.getArCustCode())
                .andEq(QArDO.subCustId, query.getArSubCustId())
                .andEq(QArDO.subCustCode, query.getArSubCustCode())
                .andEq(QArDO.ouId, query.getArOuId())
                .andEq(QArDO.ouCode, query.getArOuCode())
                .andEq(QArDO.salesmanId, query.getArSalesmanId())
                .andEq(QArDO.salesmanCode, query.getArSalesmanCode())
                .andLike(QArDO.invoiceNumber, query.getArInvoiceNumber())
                .andEq(QRecDO.ouId, query.getRecOuId())
                .andEq(QRecDO.ouCode, query.getRecOuCode())
                .andEq(QRecDO.custId, query.getRecCustId())
                .andEq(QRecDO.custCode, query.getRecCustCode())
                .andEq(QRecDO.salesmanId, query.getRecSalesmanId())
                .andEq(QRecDO.salesmanCode, query.getRecSalesmanCode())
                .andLike(QRecDO.invoiceNumber, query.getRecInvoiceNumber())
                .andIsNull(query.getHeadFlag() == null, QDO.headFlag)
                .andEq(QDO.headFlag, query.getHeadFlag())
                .build();

        // id 查询
        if (CollUtil.isNotEmpty(query.getIds())) {
            predicate = ExpressionUtils.and(
                    predicate, QDO.id.in(query.getIds())
            );
        }
        if (CollUtil.isNotEmpty(query.getWriteOffRecInOutCustList())) {
            predicate = ExpressionUtils.and(
                    predicate, QRecHeadDO.inOutCust.in(query.getWriteOffRecInOutCustList())
            );
        }
        if (CollUtil.isNotEmpty(query.getWriteOffArInOutCustList())) {
            predicate = ExpressionUtils.and(
                    predicate, QArHeadDO.inOutCust.in(query.getWriteOffArInOutCustList())
            );
        }

        if (CollUtil.isNotEmpty(query.getRecRelevanceOuCodeList())) {
            predicate = ExpressionUtils.and(
                    predicate, QRecHeadDO.relevanceOuCode.in(query.getRecRelevanceOuCodeList())
            );
        }
        if (CollUtil.isNotEmpty(query.getArRelevanceOuCodeList())) {
            predicate = ExpressionUtils.and(
                    predicate, QArHeadDO.relevanceOuCode.in(query.getArRelevanceOuCodeList())
            );
        }

        JPAQuery<FinArRecVerApplyVO> select = jpaQueryFactory.select(applyDOQBean)
                .from(QDO)
                .leftJoin(QArDO).on(QDO.id.eq(QArDO.masId))
                .leftJoin(QRecDO).on(QDO.id.eq(QRecDO.masId));
        //数据权限
        BusinessSecurityUtil.where(select, FinArRecVerApplyDO.class);
        select.where(predicate);
        select.groupBy(QDO.id,
                        QDO.inOutCust,
                        QDO.applyDocNo,
                        QDO.state,
                        QDO.verState,
                        QDO.verAmt,
                        QDO.applyDate,
                        QDO.applyUserId,
                        QDO.applyUserCode,
                        QDO.applyUserName,
                        QDO.approvalDate,
                        QDO.approvalUserId,
                        QDO.approvalUserCode,
                        QDO.approvalUserName,
                        QDO.approvalRemark,
                        QDO.headFlag,
                        QDO.proposedStatus,
                        QDO.ouCode,
                        QDO.ouName,
                        QDO.ouId,
                        QDO.schemeId,
                        QDO.verMode,
                        QDO.createTime,
                        QDO.modifyTime,
                        QDO.creator,
                        QDO.updater,
                        QDO.createUserId,
                        QDO.modifyUserId);
        return super.queryByPage(select, query.getPageRequest(), QDO.createTime.desc());
    }

    public PagingVO<FinArRecVerApplyVO> writeOffJoinPage(FinArRecVerApplyQuery query) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(QDO.state, query.getState())
                .andEq(QDO.verState, query.getVerState())
                .andLike(QDO.applyDocNo, query.getApplyDocNo())
                .andEq(QDO.applyUserId, query.getApplyUserId())
                .andLike(QDO.applyUserName, query.getApplyUserName())
                .andEq(QDO.approvalUserId, query.getApprovalUserId())
                .andLike(QDO.approvalUserName, query.getApprovalUserName())
                .andBetween(QDO.applyDate, query.getApplyDateS(), query.getApplyDateE())
                .andBetween(QDO.approvalDate, query.getApprovalDateS(), query.getApprovalDateE())

                .andEq(QArHeadDO.ouCode, query.getWriteOffArOuCode())
                .andEq(QArHeadDO.custCode, query.getWriteOffArCustCode())
                .andEq(QArHeadDO.salesmanCode, query.getWriteOffArSalesmanCode())
                .andEq(QRecHeadDO.custCode, query.getWriteOffRecCustCode())
                .andEq(QRecHeadDO.ouCode, query.getWriteOffRecOuCode())
                .andEq(QRecHeadDO.salesmanCode, query.getWriteOffRecSalesmanCode())

                .andIsNull(query.getHeadFlag() == null, QDO.headFlag)
                .andEq(QDO.headFlag, query.getHeadFlag())
                .andEq(QDO.proposedStatus, query.getProposedStatus())
                .build();

        // id 查询
        if (CollUtil.isNotEmpty(query.getIds())) {
            predicate = ExpressionUtils.and(
                    predicate, QDO.id.in(query.getIds())
            );
        }
        if (CollUtil.isNotEmpty(query.getWriteOffRecInOutCustList())) {
            predicate = ExpressionUtils.and(
                    predicate, QRecHeadDO.inOutCust.in(query.getWriteOffRecInOutCustList())
            );
        }

        if (CollUtil.isNotEmpty(query.getWriteOffArInOutCustList())) {
            predicate = ExpressionUtils.and(
                    predicate, QArHeadDO.inOutCust.in(query.getWriteOffArInOutCustList())
            );
        }
        if (CollUtil.isNotEmpty(query.getRecRelevanceOuCodeList())) {
            predicate = ExpressionUtils.and(
                    predicate, QRecHeadDO.relevanceOuCode.in(query.getRecRelevanceOuCodeList())
            );
        }

        if (CollUtil.isNotEmpty(query.getArRelevanceOuCodeList())) {
            predicate = ExpressionUtils.and(
                    predicate, QArHeadDO.relevanceOuCode.in(query.getArRelevanceOuCodeList())
            );
        }


        JPAQuery<FinArRecVerApplyVO> select = jpaQueryFactory.select(applyDOQBean)
                .from(QDO)
                .leftJoin(QArHeadDO).on(QDO.id.eq(QArHeadDO.masId))
                .leftJoin(QRecHeadDO).on(QDO.id.eq(QRecHeadDO.masId))
                .where(predicate)
                .groupBy(QDO.id,
                        QDO.inOutCust,
                        QDO.applyDocNo,
                        QDO.state,
                        QDO.verState,
                        QDO.verAmt,
                        QDO.applyDate,
                        QDO.applyUserId,
                        QDO.applyUserCode,
                        QDO.applyUserName,
                        QDO.approvalDate,
                        QDO.approvalUserId,
                        QDO.approvalUserCode,
                        QDO.approvalUserName,
                        QDO.approvalRemark,
                        QDO.headFlag,
                        QDO.proposedStatus,
                        QDO.ouCode,
                        QDO.ouName,
                        QDO.ouId,
                        QDO.schemeId,
                        QDO.verMode,
                        QDO.createTime,
                        QDO.modifyTime,
                        QDO.creator,
                        QDO.updater,
                        QDO.createUserId,
                        QDO.modifyUserId);
        //数据权限
        BusinessSecurityUtil.where(select, FinArRecVerApplyDO.class);
        return super.queryByPage(select, query.getPageRequest(), QDO.createTime.desc());
    }

    /**
     * 根据单号集合查询数据信息.
     *
     * @param applyDocNos 查询参数
     * @return 查询结果
     */
    public List<FinArRecVerApplyDO> getListByApplyNos(Collection<String> applyDocNos) {
        return super.getListByValue(QDO.applyDocNo, applyDocNos);
    }
}
